// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/samples/sio4flash/main.h $
// $Rev: 54418 $
// $Date: 2024-05-15 14:14:30 -0500 (Wed, 15 May 2024) $

// SIO4: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "sio4_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))

#define	D7						(1 << 7)
#define	D8						(1 << 8)

#define	ACT_NONE				0
#define	ACT_ERASE				1		// Erase the flash image.
#define	ACT_READ				2		// Read the flash image.
#define	ACT_WRITE				3		// Write a .rpd file to flash.

#define	FLASH_CMD_NOP			0x00
#define	FLASH_CMD_RX_SIL_ID		0x01
#define	FLASH_CMD_TX_ENABLE		0x05
#define	FLASH_CMD_ERASE_BULK	0x07
#define	FLASH_CMD_RX_BLOCK		0x0C
#define	FLASH_CMD_TX_BLOCK		0x0D

#define	PAGE_SIZE				256		// KEEP AS IS!

#define	FLASH_REG_RFR	SIO4_GSC_ENCODE(GSC_REG_TYPE_BAR2,0,0,4,0x10000)// Reprogramming Feature Register
#define	FLASH_REG_RCR	SIO4_GSC_ENCODE(GSC_REG_TYPE_BAR2,0,0,4,0x10004)// Reprogramming Check Register
#define	FLASH_REG_RIR	SIO4_GSC_ENCODE(GSC_REG_TYPE_BAR2,0,0,4,0x10008)// Reprogramming ID Register
#define	FLASH_REG_RCSR	SIO4_GSC_ENCODE(GSC_REG_TYPE_BAR2,0,0,4,0x10010)// Reprogramming Control/Status Register
#define	FLASH_REG_RSAR	SIO4_GSC_ENCODE(GSC_REG_TYPE_BAR2,0,0,4,0x10020)// Reprogramming Sector Address Register
#define	FLASH_REG_RAM	SIO4_GSC_ENCODE(GSC_REG_TYPE_BAR2,0,0,4,0x10400)// RAM Block 0 & 1


// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32		action;		// operation to perform
	s32		index;		// Device index to access.
	s32		qty;		// Number of devices found.
	s32		save;		// save the read data to file
	char*	src_file;	// points to -tx source file
	s32		verbose;	// Work verbosely?

	int		fd;

	// Device Settings

} args_t;

typedef struct
{
	int			supported;		// Is flash programming supported?
	int			board_id;		// Unique Board ID
	u8*			file_buffer;	// must allocate and free
	int			reprogram_rev;	// from RIR

	int			dev_bits;		// flash size in bits
	u8*			dev_buffer;		// must allocate and free
	int			dev_bytes;		// flash size in bytes
	int			dev_id;			// FLASH Silicon ID from RCSR
	int			dev_pages;		// number of PAGE_SIZE byte pages
	const char*	dev_model;

	u32			rcr;			// Reprogramming Check Register
	u32			rir;			// Reprogramming ID Register
	u32			rfr;			// Reprogramming Feature Register
} flash_t;



// prototypes *****************************************************************

FILE*	file_close(		FILE* file);
FILE*	file_create		(const char* name);
int		file_eof		(FILE* file, int* eof);
FILE*	file_open		(const char* name);
long	file_read_bin	(FILE* file, char* dst, size_t bytes);
long	file_read_line	(FILE* file, char* dst, size_t size);
int		file_seek		(FILE* file, long pos, int wence);
long	file_size		(FILE* file);
long	file_tell		(FILE* file);
long	file_write_bin	(FILE* file, const char* src, size_t bytes);
long	file_write_str	(FILE* file, const char* src);

int		flash_command	(const args_t* args, int cmd, int wait);
int		flash_erase		(const args_t* args);
int		flash_read		(const args_t* args, flash_t* flash);
int		flash_write		(const args_t* args, flash_t* flash);

int		get_model_number(const args_t* args, const char** model);

int		perform_tests	(const args_t* args);



#endif
