// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_z16_leg_rxc.c $
// $Rev: 23031 $
// $Date: 2013-08-27 15:06:24 -0500 (Tue, 27 Aug 2013) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_z16_leg_rxc
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_Z16_LEG_RXC service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_z16_leg_rxc(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("Cable (Legacy) Rx Clock", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_Z16_LEG_RXC, &set);

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_Z16_LEG_RXC_DISABLE:

			ptr	= "Disable";
			break;

		case SIO4_Z16_LEG_RXC_UPPER:

			ptr	= "Upper";
			break;

		case SIO4_Z16_LEG_RXC_LOWER:

			ptr	= "Lower";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


