// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_xcvr_protocol.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_xcvr_protocol
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_XCVR_PROTOCOL service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_xcvr_protocol(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("Xcvr Protocol", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_XCVR_PROTOCOL, &set);

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_XCVR_PROTOCOL_RS422_RS485:

			ptr	= "RS-422/RS-485";
			break;

		case SIO4_XCVR_PROTOCOL_RS423:

			ptr	= "RS-423";
			break;

		case SIO4_XCVR_PROTOCOL_RS232:

			ptr	= "RS-232";
			break;

		case SIO4_XCVR_PROTOCOL_RS530:

			ptr	= "RS-530, Mode 1";
			break;

		case SIO4_XCVR_PROTOCOL_RS530A:

			ptr	= "RS-530, Mode 2";
			break;

		case SIO4_XCVR_PROTOCOL_V35:

			ptr	= " V.35, Mode 1";
			break;

		case SIO4_XCVR_PROTOCOL_V35A:

			ptr	= "V.35, Mode 2";
			break;

		case SIO4_XCVR_PROTOCOL_RS422_RS423_1:

			ptr	= "RS-422/RS-423 Mixed Mode 1";
			break;

		case SIO4_XCVR_PROTOCOL_RS422_RS423_2:

			ptr	= "RS-422/RS-423 Mixed Mode 2";
			break;

		case SIO4_XCVR_PROTOCOL_DISABLE:

			ptr	= "Disabled";
			break;

		case SIO4_XCVR_PROTOCOL_UNKNOWN:

			ptr	= "Unknown";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


