// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_wait_status.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_wait_status
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_WAIT_STATUS service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		wait	Retrieve the status per the given criteria.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_wait_status(int fd, gsc_wait_t* wait)
{
	int	errs;

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_WAIT_STATUS, wait);
	return(errs);
}


