// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_usc_tx_mode.c $
// $Rev: 31468 $
// $Date: 2014-12-04 13:00:47 -0600 (Thu, 04 Dec 2014) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_usc_tx_mode
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_USC_TX_MODE service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_usc_tx_mode(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("USC Tx Mode", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_USC_TX_MODE, &set);

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_USC_MODE_ASYNC:

			ptr	= "Asynchronous";
			break;

		case SIO4_USC_MODE_ISOC:

			ptr	= "Isochronous";
			break;

		case SIO4_USC_MODE_ASY_CV:

			ptr	= "Asynchronous w/ Code Violations";
			break;

		case SIO4_USC_MODE_MONO:

			ptr	= "Monosync";
			break;

		case SIO4_USC_MODE_BSC:

			ptr	= "Bisync";
			break;

		case SIO4_USC_MODE_HDLC:

			ptr	= "HDLC";
			break;

		case SIO4_USC_MODE_TBSC:

			ptr	= "Transparent Bisync";
			break;

		case SIO4_USC_MODE_NBIP:

			ptr	= "Nine-Bit Interprocessor Protocol";
			break;

		case SIO4_USC_MODE_8023:

			ptr	= "802.3";
			break;

		case SIO4_USC_MODE_S_MONO:

			ptr	= "Slaved Monosync";
			break;

		case SIO4_USC_MODE_HDLC_L:

			ptr	= "HDLC Loop";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


