// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_usc_tx_cmd.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_usc_tx_cmd
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_USC_TX_CMD service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_usc_tx_cmd(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("USC Tx COmmand", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_USC_TX_CMD, &set);

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_USC_TX_CMD_NULL:

			ptr	= "Do Nothing";
			break;

		case SIO4_USC_TX_CMD_PRESET_CRC:

			ptr	= "Preset CRC";
			break;

		case SIO4_USC_TX_CMD_ENTER_HUNT_MODE:

			ptr	= "Entrer Hunt Mode";
			break;

		case SIO4_USC_TX_CMD_SEL_FIFO_STATUS:

			ptr	= "Select FIFO Status";
			break;

		case SIO4_USC_TX_CMD_SEL_FIFO_INT_LVL:

			ptr	= "Select FIFO Interrupt Level";
			break;

		case SIO4_USC_TX_CMD_SEL_FIFO_STS_LVL:

			ptr	= "Select FIFO Status Level";
			break;

		case SIO4_USC_TX_CMD_SEND_FRM_MSG:

			ptr	= "Send Frame/Message";
			break;

		case SIO4_USC_TX_CMD_SEND_ABORT:

			ptr	= "Send Abort";
			break;

		case SIO4_USC_TX_CMD_RST_DLE_INHIBIT:

			ptr	= "Reset DLE Inhibit";
			break;

		case SIO4_USC_TX_CMD_SET_DLE_INHIBIT:

			ptr	= "Set DLE Inhibit";
			break;

		case SIO4_USC_TX_CMD_RST_EOF_EOM:

			ptr	= "Reset EOF/EOM";
			break;

		case SIO4_USC_TX_CMD_SET_EOF_EOM:

			ptr	= "Set EOF/EOM";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


