// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_usc_send_command.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_usc_send_command
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_USC_SEND_COMMAND service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_usc_send_command(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("USC Send Command", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_USC_SEND_COMMAND, &set);

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_USC_SEND_CMD_NONE:

			ptr	= "Do Nothing";
			break;

		case SIO4_USC_SEND_CMD_RESET_H_IUS:

			ptr	= "Reset the Highest IRQ Under Service";
			break;

		case SIO4_USC_SEND_CMD_TRIG_LD_DMA:

			ptr	= "Trigger Load DMA";
			break;

		case SIO4_USC_SEND_CMD_TRIG_RX_DMA:

			ptr	= "Trigger Rx DMA";
			break;

		case SIO4_USC_SEND_CMD_TRIG_TX_DMA:

			ptr	= "Trigger Tx DMA";
			break;

		case SIO4_USC_SEND_CMD_TRIG_TX_RX_DMA:

			ptr	= "Trigger Tx and Rx DMA";
			break;

		case SIO4_USC_SEND_CMD_RX_FIFO_PURGE:

			ptr	= "Rx FIFO Purge";
			break;

		case SIO4_USC_SEND_CMD_TX_FIFO_PURGE:

			ptr	= "Tx FIFO Purge";
			break;

		case SIO4_USC_SEND_CMD_FIFOS_PURGE:

			ptr	= "Tx and Rx FIFO Purge";
			break;

		case SIO4_USC_SEND_CMD_LD_RX_CHAR_CNT:

			ptr	= "Load Rx Character Count";
			break;

		case SIO4_USC_SEND_CMD_LD_TX_CHAR_CNT:

			ptr	= "Load Tx Character Count";
			break;

		case SIO4_USC_SEND_CMD_LD_CHAR_CNTS:

			ptr	= "Load Tx and Rx Character Counts";
			break;

		case SIO4_USC_SEND_CMD_LD_TC0:

			ptr	= "Load TC0";
			break;

		case SIO4_USC_SEND_CMD_LD_TC1:

			ptr	= "Load TC1";
			break;

		case SIO4_USC_SEND_CMD_LD_TC0_TC1:

			ptr	= "Load TC0 and TC1";
			break;

		case SIO4_USC_SEND_CMD_SEL_LSB_FIRST:

			ptr	= "Select LSB First (after next chan. init.)";
			break;

		case SIO4_USC_SEND_CMD_SEL_MSB_FIRST:

			ptr	= "Select MSB First (after next chan. init.)";
			break;

		case SIO4_USC_SEND_CMD_SEL_STRAIT_MEM:

			ptr	= "Select Strait Memory";
			break;

		case SIO4_USC_SEND_CMD_SEL_SWAP_MEM:

			ptr	= "Select Swap Memory";
			break;

		case SIO4_USC_SEND_CMD_RX_PURGE:

			ptr	= "Rx Purge";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


