// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_usc_rxc_cfg.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_usc_rxc_cfg
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_USC_RXC_CFG service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_usc_rxc_cfg(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("USC RxC Configuration", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_USC_RXC_CFG, &set);

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_USC_RXC_CFG_IN_OSC:

			ptr	= "Input from the Oscillator";
			break;

		case SIO4_USC_RXC_CFG_IN_OSC_INV:

			ptr	= "Input from the Inverted Oscillator";
			break;

		case SIO4_USC_RXC_CFG_IN_0:

			ptr	= "Input A Logic Level 0";
			break;

		case SIO4_USC_RXC_CFG_IN_1:

			ptr	= "Input A Logic Level 1";
			break;

		case SIO4_USC_RXC_CFG_IN_CBL_RXC:

			ptr	= "Input from the Cable RxC Pin";
			break;

		case SIO4_USC_RXC_CFG_IN_CBL_RXAUXC:

			ptr	= "Input from the Cable RxAuxC pin";
			break;

		case SIO4_USC_RXC_CFG_OUT_RX_CLK:

			ptr	= "Output the Rx Clock";
			break;

		case SIO4_USC_RXC_CFG_OUT_RX_BYTE_CLK:

			ptr	= "Output the Rx Byte Clock";
			break;

		case SIO4_USC_RXC_CFG_OUT_SYNC:

			ptr	= "Output the Rx Sync signal";
			break;

		case SIO4_USC_RXC_CFG_OUT_BRG0:

			ptr	= "Output the BRG0 Signal";
			break;

		case SIO4_USC_RXC_CFG_OUT_BRG1:

			ptr	= "Output the BRG1 Signal";
			break;

		case SIO4_USC_RXC_CFG_OUT_CTR0:

			ptr	= "Output the CTR0 Signal";
			break;

		case SIO4_USC_RXC_CFG_OUT_DPLL_RX:

			ptr	= "Output the DPLL's R Clock Signal";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


