// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_usc_cts_leg.c $
// $Rev: 23031 $
// $Date: 2013-08-27 15:06:24 -0500 (Tue, 27 Aug 2013) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_usc_cts_leg
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_USC_CTS_LEG service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_usc_cts_leg(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("USC CTS Legacy Config", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_USC_CTS_LEG, &set);

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_USC_CTS_LEG_IN:

			ptr	= "Input";
			break;

		case SIO4_USC_CTS_LEG_OUT_0:

			ptr	= "Drive Low";
			break;

		case SIO4_USC_CTS_LEG_OUT_1:

			ptr	= "Drive High";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


