// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_usc_async_tx_stop_bit.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_usc_async_tx_stop_bit
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_USC_ASYNC_TX_STOP_BIT service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_usc_async_tx_stop_bit(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("USC Async Tx Stop Bits", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_USC_ASYNC_TX_STOP_BIT, &set);

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1:

			ptr	= "1-bits";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_2:

			ptr	= "2-bits";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_0__9_16:

			ptr	= "9/16-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_0_10_16:

			ptr	= "10/16-bit, 5/8-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_0_11_16:

			ptr	= "11/16-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_0_12_16:

			ptr	= "12/16-bit, 3/4-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_0_13_16:

			ptr	= "13/16-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_0_14_16:

			ptr	= "14/16-bit, 7/8-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_0_15_16:

			ptr	= "15/16-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1__1_16:

			ptr	= "1 and 1/16-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1__2_16:

			ptr	= "1 and 2/16-bit, 1 and 1/8-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1__3_16:

			ptr	= "1 and 3/16-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1__4_16:

			ptr	= "1 and 4/16-bit, 1 and 1/4-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1__5_16:

			ptr	= "1 and 5/16-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1__6_16:

			ptr	= "1 and 6/16-bit, 1 and 3/8-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1__7_16:

			ptr	= "1 and 7/16-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1__8_16:

			ptr	= "1 and 8/16-bit, 1 and 1/2-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1__9_16:

			ptr	= "1 and 6/16-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1_10_16:

			ptr	= "1 and 10/16-bit, 1 and 5/8-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1_11_16:

			ptr	= "1 and 11/16-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1_12_16:

			ptr	= "1 and 12/16-bit, 1 and 3/4-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1_13_16:

			ptr	= "1 and 13/16-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1_14_16:

			ptr	= "1 and 14/16-bit, 1 and 7/8-bit";
			break;

		case SIO4_USC_ASYNC_TX_STOP_BIT_1_15_16:

			ptr	= "1 and 15/16-bit";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


