// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_usc_acv_tx_stop_bit.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_usc_acv_tx_stop_bit
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_USC_ACV_TX_STOP_BIT service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_usc_acv_tx_stop_bit(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("USC Async W/ Code Violations Tx Stop Bits", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_USC_ACV_TX_STOP_BIT, &set);

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_USC_ACV_TX_STOP_BIT_1:

			ptr	= "1=bit";
			break;

		case SIO4_USC_ACV_TX_STOP_BIT_2:

			ptr	= "2-bits";
			break;

		case SIO4_USC_ACV_TX_STOP_BIT_NONE:

			ptr	= "No Stop Bits";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


