// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_tx_io_timeout.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_tx_io_timeout
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_TX_IO_TIMEOUT service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_tx_io_timeout(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("Tx I/O Timeout", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_TX_IO_TIMEOUT, &set);

	if (verbose)
	{
		if (set == -1)
		{
			ptr	= "This service is not supported by this board.";
		}
		else
		{
			sprintf(buf, "%ld seconds", (long) set);
			ptr	= buf;
		}

		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);
	}

	if (get)
		get[0]	= set;

	return(errs);
}


