// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_rx_fifo_underrun.c $
// $Rev: 23031 $
// $Date: 2013-08-27 15:06:24 -0500 (Tue, 27 Aug 2013) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_rx_fifo_underrun
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_RX_FIFO_UNDERRUN service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_rx_fifo_underrun(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("Rx FIFO Underrun", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_RX_FIFO_UNDERRUN, &set);

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_FIFO_UNDERRUN_NO:

			ptr	= "No";
			break;

		case SIO4_FIFO_UNDERRUN_YES:

			ptr	= "Yes";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


