// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_rx_fifo_reset.c $
// $Rev: 18177 $
// $Date: 2012-09-26 10:28:50 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_rx_fifo_reset
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_RX_FIFO_RESET service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		The value to supply to the service.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_rx_fifo_reset(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	s32			v		= set;

	if (verbose)
		gsc_label_index("Rx FIFO Reset", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_RX_FIFO_RESET, &set);

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case 0:

			ptr	= "The FIFO was not reset.";
			break;

		case 1:

			if (v == -1)
				ptr	= "The feature is supported.";
			else
				ptr	= "The FIFO was reset.";

			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


