// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_reg_write.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_reg_write
*
*	Purpose:
*
*		Provide a silent wrapper for the SIO4_IOCTL_REG_WRITE service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		reg		This is the register to access.
*
*		set		This is the value to apply.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_reg_write(int fd, u32 reg, u32 set)
{
	gsc_reg_t	arg;
	int			errs;

	arg.reg		= reg;
	arg.value	= set;
	arg.mask	= 0;	// unused here
	errs		= sio4_dsl_ioctl(fd, SIO4_IOCTL_REG_WRITE, &arg);
	return(errs);
}


