// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_reg_read_raw.c $
// $Rev: 23031 $
// $Date: 2013-08-27 15:06:24 -0500 (Tue, 27 Aug 2013) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_reg_read_raw
*
*	Purpose:
*
*		Provide a silent wrapper for the SIO4_IOCTL_REG_READ_RAW service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	This is the indexof the register to access.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_reg_read_raw(int fd, u32 index, u32* get)
{
	gsc_reg_t	arg;
	int			errs;

	arg.reg		= index;
	arg.value	= 0xDEADBEEF;
	arg.mask	= 0;	// unused here
	errs		= sio4_dsl_ioctl(fd, SIO4_IOCTL_REG_READ_RAW, &arg);

	if (get)
		get[0]	= arg.value;

	return(errs);
}


