// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_reg_read.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_reg_read
*
*	Purpose:
*
*		Provide a silent wrapper for the SIO4_IOCTL_REG_READ service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		reg		This is the register to access.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_reg_read(int fd, u32 reg, u32* get)
{
	gsc_reg_t	arg;
	int			errs;

	arg.reg		= reg;
	arg.value	= 0xDEADBEEF;
	arg.mask	= 0;	// unused here
	errs		= sio4_dsl_ioctl(fd, SIO4_IOCTL_REG_READ, &arg);

	if (get)
		get[0]	= arg.value;

	return(errs);
}


