// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_reg_mod.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_reg_mod
*
*	Purpose:
*
*		Provide a silent wrapper for the SIO4_IOCTL_REG_MOD service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		reg		This is the register to access.
*
*		set		This is the value to apply via the mask.
*
*		mask	These are the bits to modify.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_reg_mod(int fd, u32 reg, u32 set, u32 mask)
{
	gsc_reg_t	arg;
	int			errs;

	arg.reg		= reg;
	arg.value	= set;
	arg.mask	= mask;
	errs		= sio4_dsl_ioctl(fd, SIO4_IOCTL_REG_MOD, &arg);
	return(errs);
}


