// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_query.c $
// $Rev: 18173 $
// $Date: 2012-09-26 09:55:58 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_query
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_QUERY service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		This is the query option to access.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_query(int fd, s32 set, s32* get)
{
	int	errs;

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_QUERY, &set);

	if (get)
		get[0]	= set;

	return(errs);
}


