// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_osc_reference.c $
// $Rev: 18177 $
// $Date: 2012-09-26 10:28:50 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_osc_reference
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_OSC_REFERENCE service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_osc_reference(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	s32			v		= set;

	if (verbose)
		gsc_label_index("Oscillator Reference", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_OSC_REFERENCE, &set);

	switch (set)
	{
		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case 1:

			if (v == -1)
			{
				ptr	= "The feature is supported.";
				break;
			}

		default:

			sprintf(buf, "%ld Hz", (long) set);
			ptr	= buf;
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


