// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_osc_measure.c $
// $Rev: 23031 $
// $Date: 2013-08-27 15:06:24 -0500 (Tue, 27 Aug 2013) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_osc_measure
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_OSC_MEASURE service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_osc_measure(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;

	if (verbose)
		gsc_label_index("Oscillator Measure", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_OSC_MEASURE, &set);

	switch (set)
	{
		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		default:

			sprintf(buf, "%ld Hz, approximate", (long) set);
			ptr	= buf;
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


