// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_open.c $
// $Rev: 33918 $
// $Date: 2015-10-07 14:35:18 -0500 (Wed, 07 Oct 2015) $

#include "sio4_utils.h"



/*****************************************************************************
*
*	Function:	sio4_dev_open
*
*	Purpose:
*
*		Implement an open service.
*
*	Arguments:
*
*		index		The index of the channel to access.
*
*		show_index	The index of the board to access. Ignore if < 0.
*					This is for display purposes only.
*
*		verbose		0: errors only, !0: all output
*
*	Returned:
*
*		>= 0	The handle of the opened device.
*		< 0		There was a problem.
*
*****************************************************************************/

int sio4_dev_open(int index, int show_index, int verbose)
{
	int	fd;

	if (verbose)
		gsc_label_index("Opening SIO4", show_index);

	fd	= sio4_open(index);

	if (verbose == 0)
		;
	else if (fd >= 0)
		printf("PASS\n");
	else
		printf("FAIL <---  (ERROR: open failure)\n");

	return(fd);
}


