// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_id.c $
// $Rev: 25698 $
// $Date: 2014-03-31 15:17:04 -0500 (Mon, 31 Mar 2014) $

#include "sio4_utils.h"



//****************************************************************************
static int _id_board_jumpers(int fd, s32 qty, s32 sense, s32 value)
{
	u32	bit;
	int	i;

	if (qty > 0)
	{
		gsc_label("User Jumpers");

		if (qty < 0)
		{
			printf("UNKNOWN\n");
		}
		else if (qty == 0)
		{
			printf("(Not supported on this board.)\n");
		}
		else
		{
			printf("0x%01lX         (", (long) value);

			for (i = qty; i > 0; i--)
			{
				bit	= 0x1 << (i - 1);

				if (sense)
					printf("%s", (bit & value) ? "On" : "Off");
				else
					printf("%s", (bit & value) ? "Off" : "On");

				if ((qty > 1) && (i > 1))
					printf(",");
			}

			printf(")\n");
		}
	}

	return(0);
}



//****************************************************************************
static int _id_board_pci(
	int	fd,
	u32	vid,
	u32	did,
	u32	svid,
	u32	sid)
{
	int	errs	= 0;

	gsc_label("Vendor ID");
	printf("0x%04lX      ", (long) vid);

	if (vid == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Device ID");
	printf("0x%04lX      ", (long) did);

	if (did == 0x9056)
	{
		printf("(PCI9056)\n");
	}
	else if (did == 0x9080)
	{
		printf("(PCI9080)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Subsystem Vendor ID");
	printf("0x%04lX      ", (long) svid);

	if (svid == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Subsystem ID");
	printf("0x%04lX      ", (long) sid);

	if ((did == 0x9080) && (sid == 0x2401))
	{
		printf("(SIO4/A/B/BX/BXS)\n");
	}
	else if ((did == 0x9056) && (sid == 0x3198))
	{
		printf("(SIO4BXR/BX2/SIO8BXS/BX2)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
int sio4_id_fifo_size_total(int fd, int dash, const char** name)
{
	static char	buf[64]	= "";
	int			errs	= 0;
	s32			fifo;
	s32			model;
	char*		psz;
	s32			qty;

	errs	+= sio4_query(fd, SIO4_QUERY_FIFO_SIZE_TOTAL, &fifo);
	errs	+= sio4_query(fd, SIO4_QUERY_MODEL_BASE, &model);
	errs	+= sio4_query(fd, SIO4_QUERY_DEVICE_QTY, &qty);

	switch (model)
	{
		default:

			if (dash)
			{
				strcpy(buf, "-");
				psz	= buf + 1;
			}
			else
			{
				psz	= buf;
			}

			if (qty > 1)
				fifo	*= qty;

			if (fifo % 1024)
				sprintf(psz, "%ld", (long) fifo);
			else
				sprintf(psz, "%ldK", (long) fifo / 1024);

			break;

		case SIO4_MODEL_SIO4BX2:
		case SIO4_MODEL_SIO4BX2_SYNC:
		case SIO4_MODEL_SIO8BX2:
		case SIO4_MODEL_SIO8BX2_SYNC:

			break;
	}

	if (name)
		name[0]	= buf;

	return(errs);
}



//*****************************************************************************
int sio4_id_form_factor(int fd, const char** name, int dash)
{
	static char	buf[64];
	int			errs;
	s32			ff;

	errs	= sio4_query(fd, SIO4_QUERY_FORM_FACTOR, &ff);

	switch (ff)
	{
		default:	sprintf(buf, "UNKNOWN(%ld)", (long) ff);	break;
		case SIO4_FORM_FACTOR_PCI:		strcpy(buf, "PCI");		break;
		case SIO4_FORM_FACTOR_PCI66:	strcpy(buf, "PCI66");	break;
		case SIO4_FORM_FACTOR_PMC:		strcpy(buf, "PMC");		break;
		case SIO4_FORM_FACTOR_PMC66:	strcpy(buf, "PMC66");	break;
		case SIO4_FORM_FACTOR_CPCI:		strcpy(buf, "CPCI");	break;
		case SIO4_FORM_FACTOR_PC104P:	strcpy(buf, "PC104P");	break;
		case SIO4_FORM_FACTOR_XMC:		strcpy(buf, "XMC");		break;
		case SIO4_FORM_FACTOR_UNKNOWN:	strcpy(buf, "");		break;
		case SIO4_FORM_FACTOR_PCIE:		strcpy(buf, "PCIe");	break;
		case SIO4_FORM_FACTOR_PCIE4:	strcpy(buf, "PCIe4");	break;
	}

	if ((dash) && (buf[0]))
		strcat(buf, "-");

	if (name)
		name[0]	= buf;

	return(errs);
}



//*****************************************************************************
int sio4_id_model(int fd, const char** name)
{
	static char	buf[64];
	int			errs;
	s32			model;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_BASE, &model);

	switch (model)
	{
		default:	sprintf(buf, "UNKNOWN(%ld)", (long) model);			break;
		case SIO4_MODEL_SIO4:			strcpy(buf, "SIO4");			break;
		case SIO4_MODEL_SIO4A:			strcpy(buf, "SIO4A");			break;
		case SIO4_MODEL_SIO4A_SYNC:		strcpy(buf, "SIO4A-SYNC");		break;
		case SIO4_MODEL_SIO4AR:			strcpy(buf, "SIO4AR");			break;
		case SIO4_MODEL_SIO4AR_SYNC:	strcpy(buf, "SIO4AR-SYNC");		break;
		case SIO4_MODEL_SIO4AHRM:		strcpy(buf, "SIO4AHRM");		break;
		case SIO4_MODEL_SIO4AHRM_SYNC:	strcpy(buf, "SIO4AHRM-SYNC");	break;
		case SIO4_MODEL_SIO4B:			strcpy(buf, "SIO4B");			break;
		case SIO4_MODEL_SIO4B_SYNC:		strcpy(buf, "SIO4B-SYNC");		break;
		case SIO4_MODEL_SIO4BX:			strcpy(buf, "SIO4BX");			break;
		case SIO4_MODEL_SIO4BX_SYNC:	strcpy(buf, "SIO4BX-SYNC");		break;
		case SIO4_MODEL_SIO4BX2:		strcpy(buf, "SIO4BX2");			break;
		case SIO4_MODEL_SIO4BX2_SYNC:	strcpy(buf, "SIO4BX2-SYNC");	break;
		case SIO4_MODEL_SIO4BXR:		strcpy(buf, "SIO4BXR");			break;
		case SIO4_MODEL_SIO4BXR_SYNC:	strcpy(buf, "SIO4BXR-SYNC");	break;
		case SIO4_MODEL_SIO8BXS:		strcpy(buf, "SIO8BXS");			break;
		case SIO4_MODEL_SIO8BXS_SYNC:	strcpy(buf, "SIO8BXS-SYNC");	break;
		case SIO4_MODEL_SIO8BX2:		strcpy(buf, "SIO8BX2");			break;
		case SIO4_MODEL_SIO8BX2_SYNC:	strcpy(buf, "SIO8BX2-SYNC");	break;
	}

	if (name)
		name[0]	= buf;

	return(errs);
}



//*****************************************************************************
int sio4_id_type(int fd, const char** name)
{
	static char	buf[64];
	int			errs;
	s32			type;

	errs	= sio4_query(fd, SIO4_QUERY_SIO4_TYPE, &type);

	switch (type)
	{
		default:	sprintf(buf, "UNKNOWN(%ld)", (long) type);	break;
		case SIO4_TYPE_SIO4:		strcpy(buf, "SIO4");		break;
		case SIO4_TYPE_SIO4A:		strcpy(buf, "SIO4A");		break;
		case SIO4_TYPE_SIO4AR:		strcpy(buf, "SIO4AR");		break;
		case SIO4_TYPE_SIO4AHRM:	strcpy(buf, "SIO4AHRM");	break;
		case SIO4_TYPE_SIO4B:		strcpy(buf, "SIO4B");		break;
		case SIO4_TYPE_SIO4BX:		strcpy(buf, "SIO4BX");		break;
		case SIO4_TYPE_SIO4BX2:		strcpy(buf, "SIO4BX2");		break;
		case SIO4_TYPE_SIO4BXR:		strcpy(buf, "SIO4BXR");		break;
		case SIO4_TYPE_SIO8BX2:		strcpy(buf, "SIO8BX2");		break;
		case SIO4_TYPE_SIO8BXS:		strcpy(buf, "SIO8BXS");		break;
	}

	if (name)
		name[0]	= buf;

	return(errs);
}



/******************************************************************************
*
*	Function:	sio4_id_board
*
*	Purpose:
*
*		Identify the board.
*
*	Arguments:
*
*		fd		The handle to use to access the board.
*
*		index	The index of the board to access. Use -1 to ignore.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int sio4_id_board(int fd, int index)
{
	char		buf[64];
	u32			did;
	int			errs	= 0;
	s32			feat_fr;
	u32			fr;			// Features Register
	u32			frr;		// Firmware Revision Register
	const char*	psz		= NULL;
	s32			qty;
	s32			sense;
	u32			sid;
	u32			svid;
	s32			value;
	u32			vid;

	gsc_label_index("Board", index);

	errs	+= sio4_reg_read(fd, GSC_PCI_9080_VIDR, &vid);
	errs	+= sio4_reg_read(fd, GSC_PCI_9080_DIDR, &did);
	errs	+= sio4_reg_read(fd, GSC_PCI_9080_SVID, &svid);
	errs	+= sio4_reg_read(fd, GSC_PCI_9080_SID, &sid);
	errs	+= sio4_reg_read(fd, SIO4_GSC_FRR, &frr);
	errs	+= sio4_reg_read(fd, SIO4_GSC_FR, &fr);

	errs	+= sio4_query(fd, SIO4_QUERY_REG_FR, &feat_fr);

	errs	+= sio4_query(fd, SIO4_QUERY_USER_JUMPER_QTY, &qty);
	errs	+= sio4_query(fd, SIO4_QUERY_USER_JUMPER_SENSE, &sense);
	errs	+= sio4_query(fd, SIO4_QUERY_USER_JUMPER_VAL, &value);

	errs	+= sio4_id_form_factor(fd, &psz, 1);
	strcpy(buf, psz);

	errs	+= sio4_id_model(fd, &psz);
	strcat(buf, psz);

	errs	+= sio4_id_fifo_size_total(fd, 1, &psz);
	strcat(buf, psz);

	printf("%s\n", errs ? "" : buf);
	gsc_label_level_inc();

	errs	+= _id_board_pci(fd, vid, did, svid, sid);

	gsc_label("Firmware Revision Reg.");
	printf("0x%08lX\n", (long) frr);

	gsc_label("Features Register");
	printf("0x%08lX", (long) fr);

	if (feat_fr == 0)
		printf("  (Not supported on this board.)\n");
	else
		printf("\n");

	errs	+= _id_board_jumpers(fd, qty, sense, value);

	gsc_label_level_dec();
	return(errs);
}


