// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_close.c $
// $Rev: 33918 $
// $Date: 2015-10-07 14:35:18 -0500 (Wed, 07 Oct 2015) $

#include "sio4_utils.h"



/*****************************************************************************
*
*	Function:	sio4_dev_close
*
*	Purpose:
*
*		Implement a close service.
*
*	Arguments:
*
*		fd		The file descriptor to use.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
*****************************************************************************/

int sio4_dev_close(int fd, int index, int verbose)
{
	int	errs;
	int	sts;

	if (verbose)
		gsc_label_index("Closing SIO4", index);

	sts		= sio4_close(fd);
	errs	= (sts < 0) ? 1 : 0;

	if (verbose == 0)
		;
	else if (sts >= 0)
		printf("PASS\n");
	else
		printf("FAIL <---  (ERROR: close failure)\n");

	return(errs);
}


