// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/util_cbl_pin_status.c $
// $Rev: 18177 $
// $Date: 2012-09-26 10:28:50 -0500 (Wed, 26 Sep 2012) $

#include "sio4_utils.h"



/******************************************************************************
*
*	Function:	sio4_cbl_pin_status
*
*	Purpose:
*
*		Provide a visual wrapper for the SIO4_IOCTL_CBL_PIN_STATUS service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the board to access. Ignore if < 0.
*
*		verbose	0: errors only, !0: all output
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int sio4_cbl_pin_status(int fd, int index, int verbose, s32 set, s32* get)
{
	char	buf[128];
	int		errs;

	if (verbose)
		gsc_label_index("Cable Pin Status", index);

	errs	= sio4_dsl_ioctl(fd, SIO4_IOCTL_CBL_PIN_STATUS, &set);


	if (set == -1)
		sprintf(buf, "  (This service is not supported by this board.)");
	else
		sprintf(buf, "  (0x%lX)", (long) set);

	if (verbose)
		printf("%s%s\n", errs ? "FAIL <---" : "PASS", buf);

	if (get)
		get[0]	= set;

	return(errs);
}


