// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/utils/rtx/os_util_time.c $
// $Rev: 33967 $
// $Date: 2015-11-05 18:41:22 -0600 (Thu, 05 Nov 2015) $

#include <stdio.h>
#include <string.h>

#include "gsc_utils.h"




//*****************************************************************************
size_t os_time_delta_ms(void)
{
	static	long long	divider;
	static	long long	ms_start;
	static	int			started	= 0;

	LARGE_INTEGER		cntr;
	size_t				delta;
	LARGE_INTEGER		freq;
	long long			ms;		// milliseconds

	QueryPerformanceCounter(&cntr);

	if (started == 0)
	{
		QueryPerformanceFrequency(&freq);
		divider		= freq.QuadPart / 1000;	// we want to use milliseconds.
		ms_start	= cntr.QuadPart / divider;
		started		= 1;
	}

	ms		= cntr.QuadPart / divider;
	delta	= (size_t) (ms - ms_start);
	return(delta);
}


