// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/utils/rtx/os_util_thread.c $
// $Rev: 33967 $
// $Date: 2015-11-05 18:41:22 -0600 (Thu, 05 Nov 2015) $

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>

#include "gsc_utils.h"



// data types *****************************************************************

typedef struct
{
	int		(*function)(void* arg);
	void*	arg;
} _thread_data_t;



//*****************************************************************************
static unsigned WINAPI _thread_func(void* arg)
{
	_thread_data_t*	data	= (_thread_data_t*) arg;
	DWORD			dw;
	_thread_data_t	tmp		= data[0];

	free(arg);
	dw	= (tmp.function)(tmp.arg);
	_endthread();
	return(dw);
}



//*****************************************************************************
int os_thread_create(	os_thread_t*	thread,
						const char*		name,
						int				(*function)(void* arg),
						void*			arg)
{
	/*
	*	Under NT I've seen stack overflows that I've investigated but can't
	*	explain so I set the stack size manually to a nice comfortable value.
	*	Under 2000 I didn't see the problem. Don
	*/

	#define	STACK_SIZE	(1L * 1024 * 1024)

	_thread_data_t*	data;
	int				errs	= 0;
	unsigned		id;

	for (;;)	// A convenience loop.
	{
		if ((thread == NULL) || (name == NULL) || (function == NULL))
		{
			printf("FAIL <---  (invalid arguments)\n");
			errs++;
			break;
		}

		memset(thread, 0, sizeof(os_thread_t));
		strncpy(thread->name, name, sizeof(thread->name));
		thread->name[sizeof(thread->name) - 1]	= 0;
		data	= malloc(sizeof(_thread_data_t));

		if (data == NULL)
		{
			printf("FAIL <---  (malloc failed)\n");
			errs++;
			break;
		}

		data->function	= function;
		data->arg		= arg;
		thread->handle	= (HANDLE) _beginthreadex(	NULL,
													STACK_SIZE,
													_thread_func,
													data,
													0,
													&id);

		if (thread->handle == NULL)
		{
			free(data);
			errs	= 1;
			break;
		}

		SetThreadPriority(thread->handle, THREAD_PRIORITY_HIGHEST);
		errs	= 0;
		break;
	}

	return(errs);
}



//*****************************************************************************
int os_thread_destroy(os_thread_t* thread)
{
	int	errs	= 0;

	if (thread == NULL)
	{
		printf("FAIL <---  (invalid arguments)\n");
		errs++;
	}
	else
	{
		if (thread->handle)
			CloseHandle(thread->handle);

		memset(thread, 0, sizeof(os_thread_t));
	}

	return(errs);
}


