// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/utils/rtx/os_util_sem.c $
// $Rev: 33967 $
// $Date: 2015-11-05 18:41:22 -0600 (Thu, 05 Nov 2015) $

#include "gsc_utils.h"



//*****************************************************************************
int os_sem_create(os_sem_t* sem)
{
	int	ret;

	ret	= os_sem_create_qty(sem, 1, 1);
	return(ret);
}



//*****************************************************************************
int os_sem_create_qty(os_sem_t* sem, int cap, int put)
{
	int	ret;

	if ((sem) && (cap > 0) && (put >= 0) && (put <= cap))
	{
		memset(sem, 0, sizeof(os_sem_t));
		sem->handle	= CreateSemaphore(NULL, put, cap, NULL);
		
		if (sem->handle)
			ret	= 0;
		else
			ret	= - (int) GetLastError();
	}
	else
	{
		ret	= -EINVAL;
	}

	return(ret);
}



//*****************************************************************************
int os_sem_destroy(os_sem_t* sem)
{
	int	ret	= 0;

	if (sem == NULL)
	{
		ret	= -EINVAL;
	}
	else
	{
		if (sem->handle)
			CloseHandle(sem->handle);

		memset(sem, 0, sizeof(os_sem_t));
	}

	return(ret);
}



//*****************************************************************************
int os_sem_lock(os_sem_t* sem)
{
	int				ret;
	os_sem_get_t	sg;

	sg	= (os_sem_get_t) os_sem_lock_to(sem, INFINITE);
	ret	= (sg == OS_SEM_GET_OK) ? 0 : - (int) GetLastError();
	return(ret);
}



//*****************************************************************************
os_sem_get_t os_sem_lock_to(os_sem_t* sem, int timeout_ms)
{
	DWORD			dw;
	os_sem_get_t	ret;

	if ((sem == NULL) || (sem->handle == NULL))
	{
		ret	= OS_SEM_GET_ER;
	}
	else
	{
		if ((timeout_ms != INFINITE) && (timeout_ms < 1))
			timeout_ms	= 1;

		timeBeginPeriod(1);
		dw	= WaitForSingleObject(sem->handle, timeout_ms);
		timeEndPeriod(1);

		if (dw == WAIT_OBJECT_0)
			ret	= OS_SEM_GET_OK;
		else if (dw == WAIT_TIMEOUT)
			ret	= OS_SEM_GET_TO;
		else
			ret	= OS_SEM_GET_ER;
	}

	return(ret);
}



//*****************************************************************************
int os_sem_unlock(os_sem_t* sem)
{
	int		ret	= 0;

	if ((sem == NULL) || (sem->handle == NULL))
	{
		printf("FAIL <---  (invalid arguments)\n");
		ret	= -EINVAL;
	}
	else
	{
		ReleaseSemaphore(sem->handle, 1, NULL);
	}

	return(ret);
}


