// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/utils/rtx/os_util_id.c $
// $Rev: 33967 $
// $Date: 2015-11-05 18:41:22 -0600 (Thu, 05 Nov 2015) $

#include "sio4_lib.h"
#include "gsc_utils.h"



// #defines *******************************************************************

#define	ISEOL(_c)	((((_c) == 0)		|| \
					  ((_c) == '\r')	|| \
					  ((_c) == '\n')) ? 1 : 0)



// variables	***************************************************************

static const struct
{
	const char*	name;
	long		platform;
	long		major;
	long		minor;
} _ver_list[]	=
{
	{
		/* name		*/	"Windows 7",
		/* platform	*/	VER_PLATFORM_WIN32_NT,
		/* major	*/	6,
		/* minor	*/	1
	},
	{
		/* name		*/	"Windows Vista",
		/* platform	*/	VER_PLATFORM_WIN32_NT,
		/* major	*/	6,
		/* minor	*/	0
	},
	{
		/* name		*/	"Windows XP",
		/* platform	*/	VER_PLATFORM_WIN32_NT,
		/* major	*/	5,
		/* minor	*/	2
	},
	{
		/* name		*/	"Windows XP",
		/* platform	*/	VER_PLATFORM_WIN32_NT,
		/* major	*/	5,
		/* minor	*/	1
	},
	{
		/* name		*/	"Windows 2000",
		/* platform	*/	VER_PLATFORM_WIN32_NT,
		/* major	*/	5,
		/* minor	*/	0
	},
	{
		/* name		*/	"Windows NT",
		/* platform	*/	VER_PLATFORM_WIN32_NT,
		/* major	*/	4,
		/* minor	*/	0
	},
	{
		/* name		*/	"Windows NT",
		/* platform	*/	VER_PLATFORM_WIN32_NT,
		/* major	*/	3,
		/* minor	*/	51
	},
	{
		/* name		*/	"Windows Me",
		/* platform	*/	VER_PLATFORM_WIN32_WINDOWS,
		/* major	*/	4,
		/* minor	*/	90
	},
	{
		/* name		*/	"Windows 98",
		/* platform	*/	VER_PLATFORM_WIN32_WINDOWS,
		/* major	*/	4,
		/* minor	*/	10
	},
	{
		/* name		*/	"Windows 95",
		/* platform	*/	VER_PLATFORM_WIN32_WINDOWS,
		/* major	*/	4,
		/* minor	*/	0
	},
	{
		/* name		*/	"Win32s on Windows 3.1",
		/* platform	*/	VER_PLATFORM_WIN32s,
		/* major	*/	-1,
		/* minor	*/	-1
	},
	{
		/* name		*/	NULL,
		/* platform	*/	0,
		/* major	*/	0,
		/* minor	*/	0
	}
};



/*****************************************************************************
*
*	Function:	_id_host_processor
*
*	Purpose:
*
*		Report information on the hardware
*
*	Arguments:
*
*		None.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

static void _id_host_processor(void)
{
	const char*	arch;
	SYSTEM_INFO	si;

	GetSystemInfo(&si);

	gsc_label("Architecture");

	switch(si.wProcessorArchitecture)
	{
		default:									arch	= "not known";	break;
		case PROCESSOR_ARCHITECTURE_UNKNOWN:		arch	= "UNKNOWN";	break;
		case PROCESSOR_ARCHITECTURE_INTEL:			arch	= "INTEL";		break;
		case PROCESSOR_ARCHITECTURE_MIPS:			arch	= "MIPS";		break;
		case PROCESSOR_ARCHITECTURE_ALPHA:			arch	= "ALPHA";		break;
		case PROCESSOR_ARCHITECTURE_PPC:			arch	= "PPC";		break;
		case PROCESSOR_ARCHITECTURE_IA64:			arch	= "IA64";		break;
//		case PROCESSOR_ARCHITECTURE_IA32_ON_WIN64:	arch	= "IA32";		break;
//		case PROCESSOR_ARCHITECTURE_AMD64:			arch	= "AMD64";		break;
	}

	printf("%s\n", arch);
	gsc_label("Processors");
	printf("%d\n", (int) si.dwNumberOfProcessors);
}



/*****************************************************************************
*
*	Function:	_id_host_os
*
*	Purpose:
*
*		Report the OS.
*
*	Arguments:
*
*		buf		Put the string here. It is assumed to be large enough.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

static void _id_host_os(char* buf)
{
	int				i;
	OSVERSIONINFO	os;
	const char*		ptr;

	memset(&os, 0, sizeof(os));
	os.dwOSVersionInfoSize	= sizeof(os);
	GetVersionEx(&os);

	for (i = 0;; i++)
	{
		if (_ver_list[i].name == NULL)
			break;

		if (os.dwPlatformId != (DWORD) _ver_list[i].platform)
			continue;

		if (os.dwMajorVersion < (DWORD) _ver_list[i].major)
			continue;

		if (os.dwMinorVersion < (DWORD) _ver_list[i].minor)
			continue;

		break;
	}

	if (_ver_list[i].name == NULL)
		ptr	= "UNKNOWN";
	else
		ptr	= _ver_list[i].name;

	sprintf(buf,
			"%s, %lu.%lu.%lu%s%s",
			ptr,
			(long) os.dwMajorVersion,
			(long) os.dwMinorVersion,
			(long) os.dwBuildNumber & 0xFFFF,
			os.szCSDVersion[0] ? ", " : "",
			os.szCSDVersion);
}



/******************************************************************************
*
*	Function:	os_id_host
*
*	Purpose:
*
*		Identify the host os and machine.
*
*	Arguments:
*
*		None.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void os_id_host(void)
{
	char	buf[128];

	gsc_label("Host");
	printf("\n");
	gsc_label_level_inc();

	gsc_label("OS");
	_id_host_os(buf);
	printf("%s\n", buf);

	_id_host_processor();

	gsc_label_level_dec();
}



/******************************************************************************
*
*	Function:	os_id_driver
*
*	Purpose:
*
*		Identify the driver.
*
*	Arguments:
*
*		base	The base name of the device.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int os_id_driver(const char* base)
{
	char	buf[1024];
	int		errs	= 0;
	int		fd;
	char*	ver;

	for (;;)	// A convenience loop.
	{
		gsc_label("Driver");
		fd	= sio4_open(-1);

		if (fd == -1)
		{
			errs++;
			printf("FAIL <---  (Driver root access error.)\n");
			break;
		}

		memset(buf, 0, sizeof(buf));
		sio4_read(fd, buf, sizeof(buf));
		buf[sizeof(buf) - 1]	= 0;
		sio4_close(fd);

		ver	= strstr(buf, "version");

		if (ver == NULL)
		{
			errs++;
			printf("FAIL <---  (Driver root device content error.)\n");
			break;
		}

		// Version
		printf("Version ");

		for (ver += 9; !ISEOL(ver[0]); ver++)
			printf("%c", ver[0]);

		printf("\n");
		break;
	}

	return(errs);
}


