// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/utils/rtx/os_util_count.c $
// $Rev: 33967 $
// $Date: 2015-11-05 18:41:22 -0600 (Thu, 05 Nov 2015) $

#include <stdlib.h>

#include "sio4_lib.h"
#include "gsc_utils.h"



/******************************************************************************
*
*	Function:	os_count_boards
*
*	Purpose:
*
*		Count the number of installed boards of the given name.
*
*	Arguments:
*
*		base	The base name for the /proc file entry.
*
*	Returned:
*
*		> 0		The number of boards found.
*		== 0	No boards were found.
*
******************************************************************************/

int os_count_boards(const char* base)
{
	char		buf[1024];
	int			fd;
	const char*	key		= "boards: ";
	char*		ptr;
	int			qty		= 0;

	for (;;)	// A convenience loop.
	{
		fd	= sio4_open(-1);

		if (fd == -1)
		{
			qty	= 0;
			break;
		}

		memset(buf, 0, sizeof(buf));
		sio4_read(fd, buf, sizeof(buf));
		buf[sizeof(buf) - 1]	= 0;
		sio4_close(fd);
		ptr	= strstr(buf, key);

		if (ptr)
		{
			ptr	+= strlen(key);
			qty	= atoi(ptr);
		}

		if (qty <= 0)
			qty	= 0;

		break;
	}

	return(qty);
}


