// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/txrate/sync.c $
// $Rev: 23018 $
// $Date: 2013-08-27 14:37:56 -0500 (Tue, 27 Aug 2013) $

#include "main.h"



//*****************************************************************************
static int _show_tx_rate(long rate, FILE* file)
{
	float	err;
	int		errs	= 0;
	float	got		= 0;

	errs	+= osc_calc_program(&osc_dev, 0, 0, rate * 2, NULL, &got);

	if (errs)
		got	= (float) rate * 2;

	err	= ((got / 2) - rate) / rate * 100;
	printf("Osc %.3f / 2 -> %.3f b/s, err %.3f%%\n", got, got / 2, err);

	if (file)
		fprintf(file, "%10ld%14.3f\n", (long) rate, (float) got / 2);

	return(0);
}



//*****************************************************************************
static int _wait(int errs, int hold)
{
	gsc_label("Waiting");

	if (errs)
	{
		printf("Aborting due to errors.\n");
	}
	else
	{
		printf("%d second%s ... ", hold, (hold == 1) ? "" : "s");
		fflush(stdout);
		os_sleep_ms(1000L * hold);
		printf("Done\n");
	}

	return(0);
}



//*****************************************************************************
static int _mp_setup(int fd)
{
	static const s32	list[]	=
	{
		SIO4_XCVR_PROTOCOL_RS422_RS485,
		SIO4_XCVR_PROTOCOL_RS423,
		SIO4_XCVR_PROTOCOL_RS232,
		SIO4_XCVR_PROTOCOL_RS530,
		SIO4_XCVR_PROTOCOL_RS530A,
		SIO4_XCVR_PROTOCOL_V35,
		SIO4_XCVR_PROTOCOL_V35A,
		SIO4_XCVR_PROTOCOL_RS422_RS423_1,
		SIO4_XCVR_PROTOCOL_RS422_RS423_2,
		-1
	};

	int	errs	= 0;
	int	i;
	s32	got;

	for (i = 0;; i++)
	{
		if (list[i] == -1)
		{
			errs	= 1;
			printf(	"FAIL <---  (MP: unable to make a selection.)\n");
			break;
		}

		errs	= sio4_xcvr_protocol(fd, -1, 0, list[i], &got);

		if (errs)
			break;

		if (list[i] == got)
			break;
	}

	return(errs);
}



//*****************************************************************************
static int _rate_single(int fd, long rate, int hold)
{
	char	buf[64];
	int		errs	= 0;

	gsc_label("Rate Calculation");
	printf("\n");
	gsc_label_level_inc();
	errs	+= osc_board_startup(&osc_dev, 0);

	strcpy(buf, "Calculate ");
	gsc_label_long_comma_buf(rate, buf + strlen(buf));
	strcat(buf, " b/s");
	gsc_label(buf);

	errs	+= _show_tx_rate(rate, NULL);
	errs	+= sio4_osc_program			(fd, -1, 1, rate * 2, NULL);
	errs	+= sio4_sync_txc_cfg		(fd, -1, 1, SIO4_SYNC_TXC_CFG_INT, NULL);
	errs	+= sio4_sync_txc_idle		(fd, -1, 1, SIO4_SYNC_TXC_IDLE_YES, NULL);
	errs	+= sio4_sync_txc_idle_cfg	(fd, -1, 1, SIO4_SYNC_TXC_IDLE_CFG_ACTIVE, NULL);
	errs	+= sio4_sync_txc_src		(fd, -1, 1, SIO4_SYNC_TXC_SRC_OSC_HALF_RISE, NULL);
	errs	+= sio4_sync_txauxc_cfg		(fd, -1, 1, SIO4_SYNC_TXAUXC_CFG_OSC_HALF, NULL);
	errs	+= sio4_xcvr_protocol		(fd, -1, 1, SIO4_XCVR_PROTOCOL_RS422_RS485, NULL);
	errs	+= sio4_sync_tx_enable		(fd, -1, 1, SIO4_SYNC_ENABLE_YES, NULL);
	errs	+= sio4_xcvr_enable			(fd, -1, 1, SIO4_XCVR_ENABLE_YES, NULL);
	errs	+= _mp_setup				(fd);
	errs	+= _wait(errs, hold);
	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
static int _rate_scan(int fd, long begin, long end, int save)
{
	char	buf[64];
	int		errs	= 0;
	FILE*	file	= NULL;
	long	l;

	gsc_label("Rate Scan");
	gsc_label_long_comma(begin);
	printf(" to ");
	gsc_label_long_comma(end);
	printf("\n");
	gsc_label_level_inc();
	errs	+= osc_board_startup(&osc_dev, 0);

	if (save)
	{
		file	= fopen(FILE_NAME, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", FILE_NAME);
			errs	= 1;
		}
	}

	if (file)
	{
		fprintf(file, "# -SYNC Scan Rate\n");
		fprintf(file, "# Request   Computed\n");
		fprintf(file, "# ========  ============\n");
	}

	for (l = begin; l <= end; l++)
	{
		strcpy(buf, "Calculate ");
		gsc_label_long_comma_buf(l, buf + strlen(buf));
		strcat(buf, " b/s");
		gsc_label(buf);

		errs	+= _show_tx_rate(l, file);
	}

	if (file)
		fclose(file);

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
int sync_test(int fd, long begin, long end, int hold, int save)
{
	int	errs	= 0;

	if (begin < 0)
	{
		errs++;
		printf("ERROR: -SYNC: The begin value isn't specified\n");
	}
	else if (begin > 10000000L)
	{
		errs++;
		printf("ERROR: -SYNC: The begin value is too large. The limit is 10M.\n");
	}
	else if (end > 10000000L)
	{
		errs++;
		printf("ERROR: -SYNC: The end value is too large. The limit is 10M.\n");
	}
	else if (end < 0)
	{
		errs	+= _rate_single(fd, begin, hold);
	}
	else
	{
		errs	+= _rate_scan(fd, begin, end, save);
	}

	return(errs);
}


