// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/txrate/main.h $
// $Rev: 33969 $
// $Date: 2015-11-05 18:49:06 -0600 (Thu, 05 Nov 2015) $

#ifndef __MAIN_H__
#define __MAIN_H__

#define	__OS_MAIN_H__

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "sio4_lib.h"
#include "sio4_dsl.h"
#include "sio4_utils.h"
#include "sio4_hdlc_utils.h"
#include "sio4_sync_utils.h"



// #defines *******************************************************************

#define	VERSION			"1.7"
// 1.7	Set the default channel selection to zero.
// 1.6	Simplified error messages.
//		Additional LINTing.
// 1.5	Updated to use the newer common Linux driver sources.
// 1.4	Corrected a usage error.
// 1.3	Corrected a minor initialization bug.
//		Additional LINTing.
// 1.2	Updated some output error text.
// 1.1	Updated the prototype for sio4_id_board.
//		Updated the help text.
//		LINTed the sources.
//		Channel selection is now required on the command line.
//		Updated open/close error processing.
//		Removed continuous testing code. It is unused.
// 1.0	Initial release.

#define	FILE_NAME							"txrate.txt"

#define	__OS_MAIN_H__

#define	_8MHZ								(8L * 1000L * 1000L)
#define	_20MHZ								(20L * 1000L * 1000L)
#define	_30MHZ								(30L * 1000L * 1000L)

#define	D0									0x00000001
#define	D1									0x00000002
#define	D2									0x00000004
#define	D7									0x00000080

#define	FREQ_REF_MAX						30000000L
#define	FREQ_REF_MIN						8000000L

#define	printk								printf
#define	MEMSET								memset

#define	OSC_FREQ_REF_DEFAULT				(20L * 1000 * 1000)

#define	SIO4_FREQ_MAX						10000000L	// Max Tx Clock for the SYNC board.
#define	SIO4_FREQ_MIN						1L
#define	SIO4_GSC_POCSR_MSR_DONE				0x00000004	// Measuring is done.
#define	SIO4_GSC_POCSR_PRG_DONE				0x00000001	// Programming is done.
#define	SIO4_OSC_FREQ_REF_DEFAULT			(20L * 1000 * 1000)

#define	os_time_sleep_ms(ms)				os_sleep_ms((ms))



// data types *****************************************************************

typedef struct _chan_data_t	chan_data_t;
typedef struct _dev_data_t	dev_data_t;
typedef unsigned long		VADDR_T;

typedef struct
{
	s32						freq_want;
} sio4_osc_t;

#include "osc_cy22393.h"
#include "osc_cy22393_sio4.h"

struct _chan_data_t
{
	dev_data_t*				dev;
	int						index;
};

struct _dev_data_t
{
	chan_data_t				channel[4];

	struct
	{
		u32					osc_pd_max;
		s32					osc_chip;
	} cache;


	union
	{
		osc_cy22393_sio4_t	cy22393;
	} osc;

	struct
	{
		VADDR_T				gsc_pocsr_32;
		VADDR_T				gsc_porar_32;
		VADDR_T				gsc_pordr_32;
		VADDR_T				gsc_pord2r_32;
	} vaddr;

};



// variables ******************************************************************

extern	dev_data_t	osc_dev;



// prototypes *****************************************************************

int		async_test(int fd, long begin, long end, int hold);
int		hdlc_test(int fd, long begin, long end, int hold, int save, int best);
int		osc_calc_program(dev_data_t* dev, int chan, int verbose, long rate, FILE* file, float* got);
int		osc_test(int fd, long begin, long end, int hold, int z16c30, int mp_prog, int osc_prog, int save, int program, int measure);
int		sync_test(int fd, long begin, long end, int hold, int save);

void	gsc_irq_access_lock(dev_data_t* dev);
void	gsc_irq_access_unlock(dev_data_t* dev);

u32		os_reg_mem_rx_u32(dev_data_t* dev, VADDR_T va);
void	os_reg_mem_tx_u32(dev_data_t* dev, VADDR_T va, u32 val);

int		os_time_tick_rate(void);
void	os_time_tick_sleep(int ticks);
void	os_time_us_delay(long us);

int		osc_board_startup(dev_data_t* dev, int board);



#endif
