// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/syncc2c/main.c $
// $Rev: 33933 $
// $Date: 2015-10-07 15:15:32 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



// variables ******************************************************************

static	int		_continuous		= 0;
static	int		_ignore_errors	= 0;
static	long	_minute_limit	= 0;
static	int		_rx_index		= -1;
static	int		_test_limit		= -1;
static	int		_tx_index		= -1;



//*****************************************************************************
static int _parse_args(int argc, char** argv)
{
	char	buf[32];
	char	c;
	int		errs	= 0;
	int		i;
	int		j;
	int		k;

	printf(	"SIO4-SYNC Channel-to-Channel Data Transfer"
			" Test Utility (Version %s)\n",
			VERSION);
	printf("USAGE: syncc2c <-c> <-C> <-m#> <-n#> <tx#> <rx#>\n");
	printf("  -c   Continue testing until an error occurs.\n");
	printf("  -C   Continue testing even if errors occur.\n");
	printf("  -m#  Run for at most # minutes (a decimal number).\n");
	printf("  -n#  Repeat test at most # times (a decimal number).\n");
	printf("  tx#  Device number to transmit on (/dev/sio4X).\n");
	printf("  rx#  Device number to receive on (/dev/sio4X).\n");
	printf("  NOTE: Hit Ctrl-C to abort continuous testing.\n");
	printf("  NOTE: If Tx == Rx then disconnect cable from this channel.\n");

	gsc_label_level_inc();

	for (i = 0; i < argc; i++)
	{
		sprintf(buf, "Argument %d", i);
		gsc_label(buf);
		printf("%s\n", argv[i]);
	}

	gsc_label_level_dec();
	_rx_index	= -1;
	_tx_index	= -1;

	for (i = 1; i < argc; i++)
	{
		if (strcmp(argv[i], "-c") == 0)
		{
			_continuous		= 1;
			_ignore_errors	= 0;
			continue;
		}

		if (strcmp(argv[i], "-C") == 0)
		{
			_continuous		= 1;
			_ignore_errors	= 1;
			continue;
		}

		if ((argv[i][0] == '-') && (argv[i][1] == 'm') && (argv[i][2]))
		{
			j	= sscanf(&argv[i][2], "%d%c", &k, &c);

			if ((j == 1) && (k > 0))
			{
				_minute_limit	= k;
				continue;
			}

			errs	= 1;
			printf("ERROR: invalid argument: %s\n", argv[i]);
			break;
		}

		if ((argv[i][0] == '-') && (argv[i][1] == 'n') && (argv[i][2]))
		{
			j	= sscanf(&argv[i][2], "%d%c", &k, &c);

			if ((j == 1) && (k > 0))
			{
				_test_limit	= k;
				continue;
			}

			errs	= 1;
			printf("ERROR: invalid argument: %s\n", argv[i]);
			break;
		}

		if (_tx_index < 0)
		{
			j	= sscanf(argv[i], "%d%c", &k, &c);

			if ((j == 1) && (k >= 0))
			{
				_tx_index	= k;
				continue;
			}

			errs	= 1;
			printf("ERROR: invalid transmit channel index: %s\n", argv[i]);
			break;
		}

		if (_rx_index < 0)
		{
			j	= sscanf(argv[i], "%d%c", &k, &c);

			if ((j == 1) && (k >= 0))
			{
				_rx_index	= k;
				continue;
			}

			errs	= 1;
			printf("ERROR: invalid receive channel index: %s\n", argv[i]);
			break;
		}

		errs	= 1;
		printf("ERROR: extraneous argument: %s\n", argv[i]);
		break;
	}

	if (errs)
	{
	}
	else if (_tx_index < 0)
	{
		errs	= 1;
		printf("ERROR: transmit channel index not specified\n");
	}
	else if (_rx_index < 0)
	{
		errs	= 1;
		printf("ERROR: receive channel index not specified\n");
	}

	return(errs);
}



//*****************************************************************************
static int _perform_tests(int tx, int rx)
{
	int			errs	= 0;
	const char*	psz;
	struct tm*	stm;
	time_t		tt;

	time(&tt);
	stm	= localtime(&tt);
	psz	= asctime(stm);
	gsc_label("Performing Test");
	printf("%s", psz);

	errs	+= io_test(tx, _tx_index, rx, _rx_index);

	return(errs);
}



/******************************************************************************
*
*	Function:	main
*
*	Purpose:
*
*		Control the overall operation of the application.
*
*	Arguments:
*
*		argc	The number of command line arguments.
*
*		argv	The list of command line arguments.
*
*	Returned:
*
*		EXIT_SUCCESS	No errors were encounterred.
*		EXIT_FAILURE	One or more errors were encounterred.
*
******************************************************************************/

int main(int argc, char **argv)
{
	int		errs		= 0;
	time_t	exec		= time(NULL);
	long	failures	= 0;
	long	hours;
	long	mins;
	time_t	now;
	long	passes		= 0;
	int		qty;
	int		ret			= EXIT_SUCCESS;
	int		rx;
	long	secs;
	time_t	t_limit;
	time_t	test;
	long	tests		= 0;
	int		tx;

	for (;;)
	{
		gsc_label_init(28);
		test	= time(NULL);
		errs	= _parse_args(argc, argv);

		if (errs)
			break;

		os_id_host();
		errs	+= os_id_driver(SIO4_BASE_NAME);

		if (errs)
			break;

		sio4_sync_id_library();
		t_limit	= exec + (_minute_limit * 60);
		qty		= os_count_boards(SIO4_BASE_NAME);

		if (qty <= 0)
			break;

		tx		= sio4_dev_open(_tx_index, _tx_index, 1);
		errs	+= (tx == -1) ? 1 : 0;
		rx		= tx;

		if (_rx_index != _tx_index)
		{
			rx		= sio4_dev_open(_rx_index, _rx_index, 1);
			errs	+= (rx == -1) ? 1 : 0;
		}

		if (errs == 0)
		{
			gsc_label_level_inc();
			errs	+= sio4_id_board(tx, _tx_index);
			gsc_label_level_dec();

			if (_rx_index != _tx_index)
			{
				gsc_label_level_inc();
				errs	+= sio4_id_board(rx, _rx_index);
				gsc_label_level_dec();
			}
		}

		if (errs)
		{
			printf(	"Skipping tests (device access error%s).\n",
					(errs == 1) ? "" : "s");
		}
		else
		{
			errs	+= _perform_tests(tx, rx);
		}

		errs	+= sio4_dev_close(tx, _tx_index, 1);

		if (_rx_index != _tx_index)
			errs	+= sio4_dev_close(rx, _rx_index, 1);

		now	= time(NULL);
		tests++;

		if (errs)
		{
			failures++;
			printf(	"\nRESULTS: FAIL <---  (%d error%s)",
					errs,
					(errs == 1) ? "" : "s");
		}
		else
		{
			passes++;
			printf("\nRESULTS: PASS");
		}

		secs	= (long) (now - test);
		hours	= secs / 3600;
		secs	= secs % 3600;
		mins	= secs / 60;
		secs	= secs % 60;
		printf(" (duration %ld:%ld:%02ld)\n", hours, mins, secs);

		secs	= (long) (now - exec);
		hours	= secs / 3600;
		secs	= secs % 3600;
		mins	= secs / 60;
		secs	= secs % 60;
		printf(	"SUMMARY: tests %ld, pass %ld, fail %ld"
			" (duration %ld:%ld:%02ld)\n\n",
			tests,
			passes,
			failures,
			hours,
			mins,
			secs);

		if ((_test_limit > 0) && (_test_limit <= tests))
			break;

		if (_continuous == 0)
			break;

		if ((_ignore_errors == 0) && (errs))
			break;

		if ((_minute_limit) && (now >= t_limit))
			break;
	}

	if ((errs) || (failures))
		ret	= EXIT_FAILURE;

	return(ret);
}



