// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/lib/version.c $
// $Rev: 23644 $
// $Date: 2013-10-22 11:34:58 -0500 (Tue, 22 Oct 2013) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_sync_version
*
*	Purpose:
*
*		Report the library version number to the caller. The version number
*		is given as an integer with the form major * 100 + minor.
*
*	Arguments:
*
*		version	The version number is recorded here.
*
*		built	The build date and time is recorded here.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void sio4_sync_version(const char** version, const char** built)
{
	static const char*	blt	= __DATE__ ", " __TIME__;
	static const char*	ver	= SIO4_SYNC_LIB_VER;

	if (version)
		version[0]	= ver;

	if (built)
		built[0]	= blt;
}



