// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/lib/tx.c $
// $Rev: 33922 $
// $Date: 2015-10-07 14:59:29 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_sync_tx_get
*
*	Purpose:
*
*		Retrieve the current Tx specific SYNC configuration settings.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		tx		Record the settings here.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sio4_sync_tx_get(int fd, sio4_sync_tx_t* tx)
{
	int	ret	= 0;
	int	sts;
	s32	set;

	// Tx Enable
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TX_ENABLE, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->enable	= set;

	// Tx FIFO Empty Configuration
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_TX_FIFO_EMPTY_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->empty_cfg	= set;

	// Tx Least Significant Bit First
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TX_BIT_ORDER, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->bit_order	= set;

	// Tx Word Size
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TX_WORD_SIZE, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->word_size	= set;

	// Tx Gap Size
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TX_GAP_SIZE, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->gap_size	= set;

	// Tx Clock Configuration
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXC_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->clock.cfg	= set;

	// Tx Clock Polarity
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXC_POL, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->clock.pol	= set;

	// Tx Clock Source
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXC_SRC, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->clock.src	= set;

	// Tx Clock Idle
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXC_IDLE, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->clock.idle	= set;

	// Tx Clock Idle Configuration
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXC_IDLE_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->clock.idle_cfg	= set;

	// Tx Data Configuration
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXD_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->data.cfg	= set;

	// Tx Data Idle
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXD_IDLE_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->data.idle	= set;

	// Tx Data Legacy
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_LEG_TXD_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->data.legacy	= set;

	// Tx Envelope Configuration
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXE_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->env.cfg	= set;

	// Tx Envelope Polarity
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXE_POL, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->env.pol	= set;

	// Tx Aux Clock
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXAUXC_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->aux_clock	= set;

	// Tx Spare
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXSP_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	tx->spare	= set;

	return(ret);
}



/******************************************************************************
*
*	Function:	sio4_sync_tx_set
*
*	Purpose:
*
*		Update the current Tx specific SYNC configuration.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		tx		The setting to apply.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sio4_sync_tx_set(int fd, const sio4_sync_tx_t* tx)
{
	int	ret	= 0;
	int	sts;
	s32	set;

	// Tx Enable
	set	= tx->enable;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TX_ENABLE, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx FIFO Empty Configuration

	set	= tx->empty_cfg;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_TX_FIFO_EMPTY_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Least Significant Bit First

	set	= tx->bit_order;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TX_BIT_ORDER, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Word Size
	set	= tx->word_size;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TX_WORD_SIZE, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Gap Size
	set	= tx->gap_size;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TX_GAP_SIZE, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Clock Configuration
	set	= tx->clock.cfg;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXC_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Clock Polarity
	set	= tx->clock.pol;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXC_POL, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Clock Source
	set	= tx->clock.src;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXC_SRC, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Clock Idle
	set	= tx->clock.idle;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXC_IDLE, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Clock Idle Configuration
	set	= tx->clock.idle_cfg;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXC_IDLE_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Data Configuration
	set	= tx->data.cfg;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXD_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Data Idle
	set	= tx->data.idle;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXD_IDLE_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Data Legacy
	set	= tx->data.legacy;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_LEG_TXD_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Envelope Configuration
	set	= tx->env.cfg;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXE_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Envelope Polarity
	set	= tx->env.pol;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXE_POL, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Aux Clock

	set	= tx->aux_clock;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXAUXC_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Tx Spare
	set	= tx->spare;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXSP_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	return(ret);
}



