// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/lib/sync.c $
// $Rev: 33922 $
// $Date: 2015-10-07 14:59:29 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_sync_get
*
*	Purpose:
*
*		Retrieve the current general SYNC configuration settings.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		sync	Record the settings here.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sio4_sync_get(int fd, sio4_sync_t* sync)
{
	s32	dce_dte;
	s32	lb;
	int	ret		= 0;
	int	sts;
	s32	xcvr;

	// DCE/DTE
	dce_dte	= -1;
	sts		= sio4_ioctl(fd, SIO4_IOCTL_CBL_MODE, &dce_dte);
	ret		= ret ? ret : (sts < 0) ? -sts : sts;

	// Transceiver Enable
	xcvr	= -1;
	sts		= sio4_ioctl(fd, SIO4_IOCTL_XCVR_ENABLE, &xcvr);
	ret		= ret ? ret : (sts < 0) ? -sts : sts;

	// Extract settings.

	if (xcvr == SIO4_XCVR_ENABLE_NO)
	{
		sync->dce_enable	= 0;
		sync->dte_enable	= 0;
	}
	else if (dce_dte == SIO4_CBL_MODE_DCE)
	{
		sync->dce_enable	= 1;
		sync->dte_enable	= 0;
	}
	else
	{
		sync->dce_enable	= 0;
		sync->dte_enable	= 1;
	}

	// Loopback
	lb	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_LOOP_BACK, &lb);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	if (lb == SIO4_LOOP_BACK_INTERNAL)
	{
		// Loopback: Internal
		sync->lb.enable		= 1;
		sync->lb.internal	= 1;
	}
	else if (lb == SIO4_LOOP_BACK_EXTERNAL)
	{
		// Loopback: External
		sync->lb.enable		= 1;
		sync->lb.internal	= 0;
	}
	else
	{
		// Loopback: Disabled
		sync->lb.enable		= 0;
		sync->lb.internal	= 0;
	}

	return(ret);
}



/******************************************************************************
*
*	Function:	sio4_sync_set
*
*	Purpose:
*
*		Update the current general SYNC configuration.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		sync	The setting to apply.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sio4_sync_set(int fd, const sio4_sync_t* sync)
{
	s32	dce_dte;
	s32	lb;
	int	sts;
	int	ret	= 0;
	s32	xcvr;

	// DCE/DTE

	if (sync->dce_enable)
	{
		dce_dte	= SIO4_CBL_MODE_DCE;
		xcvr	= SIO4_XCVR_ENABLE_YES;
	}
	else if (sync->dte_enable)
	{
		dce_dte	= SIO4_CBL_MODE_DTE;
		xcvr	= SIO4_XCVR_ENABLE_YES;
	}
	else
	{
		dce_dte	= SIO4_CBL_MODE_DTE;
		xcvr	= SIO4_XCVR_ENABLE_NO;
	}

	sts	= sio4_ioctl(fd, SIO4_IOCTL_CBL_MODE, &dce_dte);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	sts	= sio4_ioctl(fd, SIO4_IOCTL_XCVR_ENABLE, &xcvr);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Loopback

	if (sync->lb.enable == 0)
		lb	= SIO4_LOOP_BACK_DISABLE;
	else if (sync->lb.internal)
		lb	= SIO4_LOOP_BACK_INTERNAL;
	else
		lb	= SIO4_LOOP_BACK_EXTERNAL;

	sts	= sio4_ioctl(fd, SIO4_IOCTL_LOOP_BACK, &lb);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	return(ret);
}



