// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/lib/rx.c $
// $Rev: 33922 $
// $Date: 2015-10-07 14:59:29 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_sync_rx_get
*
*	Purpose:
*
*		Retrieve the current Rx specific SYNC configuration settings.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		rx		Record the settings here.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sio4_sync_rx_get(int fd, sio4_sync_rx_t* rx)
{
	int	ret	= 0;
	int	sts;
	s32	set;

	// Rx Enable
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RX_ENABLE, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	rx->enable	= set;

	// Rx Least Significant Bit First
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RX_BIT_ORDER, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	rx->bit_order	= set;

	// Rx Count Reset
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RX_COUNT_ERROR, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	rx->reset	= (set == SIO4_SYNC_RX_COUNT_ERROR_YES) ? 1 : 0;

	// Rx Word Size
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RX_BIT_COUNT, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	rx->word_size	= set;

	// Rx Clock Configuration
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RXC_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	rx->clock.cfg	= set;

	// Rx Clock Polarity
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RXC_POL, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	rx->clock.pol	= set;

	// Rx Data Configuration
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RXD_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	rx->data.cfg	= set;

	// Rx Data Legacy
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_LEG_RXD_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	rx->data.legacy	= set;

	// Rx Envelope Configuration
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RXE_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	rx->env.cfg	= set;

	// Rx Envelope Polarity
	set	= -1;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RXE_POL, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;
	rx->env.pol	= set;

	return(ret);
}



/******************************************************************************
*
*	Function:	sio4_sync_rx_set
*
*	Purpose:
*
*		Update the current Rx specific SYNC configuration.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		rx		The setting to apply.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sio4_sync_rx_set(int fd, const sio4_sync_rx_t* rx)
{
	int	ret	= 0;
	int	sts;
	s32	set;

	// Rx Enable
	set	= rx->enable;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RX_ENABLE, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Rx Least Significant Bit First

	set	= rx->bit_order;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RX_BIT_ORDER, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Rx Count Reset

	if (rx->reset)
		set	= 1;
	else
		set	= 0;

	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RX_COUNT_RESET, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Rx Word Size: this is a read only setting

	// Rx Clock Configuration
	set	= rx->clock.cfg;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RXC_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Rx Clock Polarity
	set	= rx->clock.pol;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RXC_POL, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Rx Data Configuration
	set	= rx->data.cfg;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RXD_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Rx Data Legacy
	set	= rx->data.legacy;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_LEG_RXD_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Rx Envelope Configuration
	set	= rx->env.cfg;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RXE_CFG, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	// Rx Envelope Polarity
	set	= rx->env.pol;
	sts	= sio4_ioctl(fd, SIO4_IOCTL_SYNC_RXE_POL, &set);
	ret	= ret ? ret : (sts < 0) ? -sts : sts;

	return(ret);
}


