// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/lib/main.c $
// $Rev: 23189 $
// $Date: 2013-09-30 17:56:34 -0500 (Mon, 30 Sep 2013) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_sync_reg_mod
*
*	Purpose:
*
*		Perform a read-modify-write operation on an SIO4-SYNC register.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		reg		The register to access.
*
*		value	Record the value here.
*
*		mask	The set of bits to modity.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sio4_sync_reg_mod(int fd, u32 reg, u32 value, u32 mask)
{
	s32	sync;
	int	ret;

	ret	= sio4_query(fd, SIO4_QUERY_MODEL_SYNC, &sync);

	if (ret)
	       ;
	else if (sync == 0)
		ret	= EINVAL;
	else
		ret	= sio4_reg_mod(fd, reg, value, mask);

	return(ret);
}



/******************************************************************************
*
*	Function:	sio4_sync_reg_read
*
*	Purpose:
*
*		Read a register if the SIO4 is a SYNC board.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		reg		The register to access.
*
*		value	Record the value here.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sio4_sync_reg_read(int fd, u32 reg, u32* value)
{
	s32	sync;
	int	ret;

	ret	= sio4_query(fd, SIO4_QUERY_MODEL_SYNC, &sync);

	if (ret)
	       ;
	else if (sync == 0)
		ret	= EINVAL;
	else
		ret	= sio4_reg_read(fd, reg, value);

	return(ret);
}


