// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/gpio/xcvr.c $
// $Rev: 33934 $
// $Date: 2015-10-07 15:20:21 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
int xcvr_test(int fd, int xcvr)
{
	static const struct
	{
		s32			val;
		const char*	name;
	} list[]	=
	{
		// val								name
		{ SIO4_XCVR_PROTOCOL_RS232,			"RS-232"		},
		{ SIO4_XCVR_PROTOCOL_RS422_RS485,	"RS-422/RS-485"	},
		{ SIO4_XCVR_PROTOCOL_RS423,			"RS-423"		},
		{ SIO4_XCVR_PROTOCOL_RS422_RS423_1,	"RS-423 #1"		},
		{ SIO4_XCVR_PROTOCOL_RS422_RS423_2,	"RS-423 #2"		},
		{ SIO4_XCVR_PROTOCOL_RS530,			"RS-530"		},
		{ SIO4_XCVR_PROTOCOL_RS530A,		"RS-530A"		},
		{ SIO4_XCVR_PROTOCOL_V35,			"V.35"			},
		{ SIO4_XCVR_PROTOCOL_V35A,			"V.35A"			},
		{ SIO4_XCVR_PROTOCOL_UNKNOWN,		"UNKNOWN"		}
	};

	int	errs	= 0;
	int	i;
	int	sts;
	s32	val;

	gsc_label("Transceivers");

	if (xcvr == SIO4_XCVR_PROTOCOL_UNKNOWN)
	{
		// Use the first selectable option.

		for (i = 0;; i++)
		{
			if (list[i].val == SIO4_XCVR_PROTOCOL_UNKNOWN)
			{
				printf("SKIPPED  (%s)\n", list[i].name);
				break;
			}

			val	= list[i].val;
			sts	= sio4_ioctl(fd, SIO4_IOCTL_XCVR_PROTOCOL, &val);

			if (sts < 0)
			{
				// Either this protocol is unsupported or there was an error.
				continue;
			}

			// This protocol is supported.
			printf("PASS  (%s)\n", list[i].name);
			break;
		}
	}
	else
	{
		// Use the option specified by the caller.

		for (i = 0;; i++)
		{
			if (list[i].val == SIO4_XCVR_PROTOCOL_UNKNOWN)
			{
				printf("SKIPPED  (%s)\n", list[i].name);
				break;
			}

			if (xcvr != list[i].val)
				continue;

			val		= xcvr;
			sts		= sio4_ioctl(fd, SIO4_IOCTL_XCVR_PROTOCOL, &val);
			errs	= (sts < 0) ? 1 : 0;
			printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", list[i].name);
			break;
		}
	}

	return(errs);
}


