// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/gpio/txd.c $
// $Rev: 33934 $
// $Date: 2015-10-07 15:20:21 -0500 (Wed, 07 Oct 2015) $

#include "main.h"


//*****************************************************************************
static int _gpio_enable(int fd)
{
	int	errs;
	int	sts;
	s32	val;

	val		= SIO4_SYNC_TXD_CFG_OUT_0;
	sts		= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXD_CFG, &val);
	errs	= (sts < 0) ? 1 : 0;
	return(errs);
}



//*****************************************************************************
static int _gpio_disable(int fd)
{
	int	errs;
	int	sts;
	s32	val;

	val		= SIO4_SYNC_TXD_CFG_ACTIVE_HI;
	sts		= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXD_CFG, &val);
	errs	= (sts < 0) ? 1 : 0;
	return(errs);
}



//*****************************************************************************
static int _gpio_out(int fd, int level)
{
	int	errs;
	int	sts;
	s32	val;

	if (level)
		val	= SIO4_SYNC_TXD_CFG_OUT_1;
	else
		val	= SIO4_SYNC_TXD_CFG_OUT_0;

	sts		= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXD_CFG, &val);
	errs	= (sts < 0) ? 1 : 0;
	return(errs);
}



//*****************************************************************************
static int _gpio_in(int fd, int* level)
{
	int			errs;
	int			sts;
	gsc_reg_t	reg;

	reg.reg		= SIO4_GSC_PSTSR;
	reg.value	= 0xDEADBEEF;
	reg.mask	= 0;
	sts			= sio4_ioctl(fd, SIO4_IOCTL_REG_READ, &reg);
	errs		= (sts < 0) ? 1 : 0;

	if (reg.value & D5)	// D5 = TxD Output State
		level[0]	= 1;
	else
		level[0]	= 0;

	return(errs);
}



//*****************************************************************************
int txd_test(int fd, int legacy, int seconds)
{
	int	errs	= 0;
	int	supported;

	gsc_label("TxD (Output)");
	errs	= pstsr_support_test(fd, D5, "TxD", &supported);

	if ((errs) || (supported == 0))
	{
	}
	else if (legacy)
	{
		printf("SKIPPED	(Legacy operation not implemented.)\n");
	}
	else
	{
		errs	+= toggle_bit_test(
					fd,
					seconds,
					_gpio_enable,
					_gpio_disable,
					_gpio_out,
					_gpio_in);
	}

	return(errs);
}


