// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/gpio/service.c $
// $Rev: 33934 $
// $Date: 2015-10-07 15:20:21 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
static int _wait_for_bit(int fd, int level, int* state_errs, int (*gpio_in)(int fd, int* level))
{
	int		errs	= 0;
	long	ms_end;
	long	ms_now;
	int		rx;

	ms_end	= os_time_delta_ms();
	ms_end	+= 1;

	for (;;)
	{
		errs	+= (gpio_in)(fd, &rx);

		if ((errs) || (rx == level))
			break;

		ms_now	= os_time_delta_ms();

		if (ms_now >= ms_end)
		{
			state_errs[0]++;
			break;
		}
	}

	return(errs);
}


//*****************************************************************************
int pstsr_support_test(int fd, int bit, const char* name, int* supported)
{
	int	errs;
	s32	pstsr;
	int	sts;

	pstsr	= SIO4_QUERY_REG_PSTSR_BITS;
	sts		= sio4_ioctl(fd, SIO4_IOCTL_QUERY, &pstsr);
	errs	= (sts < 0) ? 1 : 0;

	if (pstsr & bit)
	{
		supported[0]	= 1;
	}
	else
	{
		supported[0]	= 0;
		printf("SKIPPED	(%s state not readable.)\n", name);
	}

	return(errs);
}



//*****************************************************************************
int toggle_bit_test(
	int fd,
	int	seconds,
	int	(*gpio_enable)(int fd),
	int	(*gpio_disable)(int fd),
	int	(*gpio_out)(int fd, int level),
	int	(*gpio_in)(int fd, int* level))
{
	long	count;
	int		errs	= 0;
	int		errs_hi	= 0;
	int		errs_lo	= 0;
	long	ms_end;
	long	ms_now;

	errs	+= (gpio_enable)(fd);
	ms_end	= os_time_delta_ms();
	ms_end	+= 1000L * seconds;

	for (count = 0;;)
	{
		errs	+= (gpio_out)(fd, 0);
		errs	+= _wait_for_bit(fd, 0, &errs_lo, gpio_in);

		errs	+= (gpio_out)(fd, 1);
		errs	+= _wait_for_bit(fd, 1, &errs_hi, gpio_in);

		count++;

		if (seconds <= 0)
		{
			if (count >= 1000)
				break;
			else
				continue;
		}

		ms_now	= os_time_delta_ms();

		if (ms_now >= ms_end)
			break;
	}

	errs	+= (gpio_disable)(fd);

	if ((errs) || (errs_hi) || (errs_lo))
	{
		printf(	"FAIL <---  (iterations: %ld, errors: low %d, high %d, other %d)\n",
				count,
				errs_lo,
				errs_hi,
				errs);
		errs	= 1;
	}
	else
	{
		printf("PASS\n");
	}

	return(errs);
}
