// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/gpio/rxauxc.c $
// $Rev: 33934 $
// $Date: 2015-10-07 15:20:21 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
static int _gpio_enable(int fd)
{
	int	errs;
	int	sts;
	s32	val;

	// This configures TxAuxC as GPIO output, which is hardwired to RxAuxC input.

	val		= SIO4_SYNC_TXAUXC_CFG_OUT_0;
	sts		= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXAUXC_CFG, &val);
	errs	= (sts < 0) ? 1 : 0;

	// No explicit action is needed regarding RxAuxC.

	return(errs);
}



//*****************************************************************************
static int _gpio_disable(int fd)
{
	int	errs;
	int	sts;
	s32	val;

	// This merely restores TxAuxC to its default operation.

	val		= SIO4_SYNC_TXAUXC_CFG_TRI;
	sts		= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXAUXC_CFG, &val);
	errs	= (sts < 0) ? 1 : 0;

	// No explicit action is needed regarding RxAuxC.

	return(errs);
}



//*****************************************************************************
static int _gpio_out(int fd, int level)
{
	int	errs;
	int	sts;
	s32	val;

	// Adjusting TxAuxC is done for testing purposes only.

	if (level)
		val	= SIO4_SYNC_TXAUXC_CFG_OUT_1;
	else
		val	= SIO4_SYNC_TXAUXC_CFG_OUT_0;

	sts		= sio4_ioctl(fd, SIO4_IOCTL_SYNC_TXAUXC_CFG, &val);
	errs	= (sts < 0) ? 1 : 0;
	return(errs);
}



//*****************************************************************************
static int _gpio_in(int fd, int* level)
{
	int			errs;
	int			sts;
	gsc_reg_t	reg;

	reg.reg		= SIO4_GSC_PSTSR;
	reg.value	= 0xDEADBEEF;
	reg.mask	= 0;
	sts			= sio4_ioctl(fd, SIO4_IOCTL_REG_READ, &reg);
	errs		= (sts < 0) ? 1 : 0;

	if (reg.value & D3)	// D3 = RxAuxC Input State
		level[0]	= 1;
	else
		level[0]	= 0;

	return(errs);
}



//*****************************************************************************
int rxauxc_test(int fd, int legacy, int seconds)
{
	int	errs	= 0;
	int	supported;

	gsc_label("RxAuxC (Input <- TxAuxC)");
	errs	= pstsr_support_test(fd, D3, "RxAuxC", &supported);

	if ((errs) || (supported == 0))
	{
	}
	else if (legacy)
	{
		printf("SKIPPED	(Legacy operation not implemented.)\n");
	}
	else
	{
		errs	+= toggle_bit_test(
					fd,
					seconds,
					_gpio_enable,
					_gpio_disable,
					_gpio_out,
					_gpio_in);
	}

	return(errs);
}


