// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/gpio/main.h $
// $Rev: 33970 $
// $Date: 2015-11-05 18:50:55 -0600 (Thu, 05 Nov 2015) $

#ifndef __MAIN_H__
#define __MAIN_H__

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "sio4_lib.h"
#include "sio4_utils.h"
#include "sio4_sync_utils.h"


// #defines *******************************************************************

#define	VERSION			"1.3"
// 1.3	Changed the default device index to zero.
// 1.2	Set the default channel selection to zero.
// 1.1	Updated per changes to API prototypes and return values.
//		Additional LINTing.
//		Replaced some time code with calls to OS utility code.
//		Used API services were possible.
// 1.0	Initial release.

#define	D0				(0x1 << 0)
#define	D1				(0x1 << 1)
#define	D2				(0x1 << 2)
#define	D3				(0x1 << 3)
#define	D4				(0x1 << 4)
#define	D5				(0x1 << 5)
#define	D6				(0x1 << 6)
#define	D7				(0x1 << 7)
#define	D8				(0x1 << 8)
#define	D9				(0x1 << 9)



// prototypes *****************************************************************

int	cable_test(int fd, int* legacy);
int	pstsr_support_test(int fd, int bit, const char* name, int* supported);
int	rxauxc_test(int fd, int legacy, int seconds);
int	rxc_test(int fd, int legacy, int seconds);
int	rxd_test(int fd, int legacy, int seconds);
int	rxe_test(int fd, int legacy, int seconds);
int	rxspare_test(int fd, int legacy, int seconds);
int	txauxc_test(int fd, int legacy, int seconds);
int	txc_test(int fd, int legacy, int seconds);
int	txd_test(int fd, int legacy, int seconds);
int	txe_test(int fd, int legacy, int seconds);
int	txspare_test(int fd, int legacy, int seconds);
int	xcvr_test(int fd, int xcvr);

int toggle_bit_test(
	int fd,
	int	seconds,
	int	(*gpio_enable)(int fd),
	int	(*gpio_disable)(int fd),
	int	(*gpio_out)(int fd, int level),
	int	(*gpio_in)(int fd, int* level));



#endif
