// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/gpio/cable.c $
// $Rev: 28298 $
// $Date: 2014-07-31 13:14:39 -0500 (Thu, 31 Jul 2014) $

#include "main.h"



//*****************************************************************************
int cable_test(int fd, int* legacy)
{
	int			errs	= 0;
	sio4_sync_t	sync;

	gsc_label("Cable Configuration");
	legacy[0]		= 0;
	errs			+= sio4_sync_get(fd, &sync);
	sync.dce_enable	= 1;
	sync.dte_enable	= 1;
	errs			+= sio4_sync_set(fd, &sync);
	errs			+= sio4_sync_get(fd, &sync);

	if (errs)
	{
		printf("FAIL <---\n");
	}
	else if (sync.dce_enable)
	{
		printf("PASS  (DCE)\n");
	}
	else if (sync.dte_enable)
	{
		printf("PASS  (DTE)\n");
	}
	else
	{
		printf("PASS  (Legacy)\n");
		legacy[0]	= 1;
	}

	return(errs);
}


