// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/services/services.c $
// $Rev: 33972 $
// $Date: 2015-11-05 19:03:11 -0600 (Thu, 05 Nov 2015) $

#include "main.h"



// #defines *******************************************************************

#define	ARRAY_ELEMENTS(a)	(sizeof((a))/sizeof((a)[0]))
#define	ENTRY(a)			#a, a

#define	FLAG_PRESENT		0x0001
#define	FLAG_DEFINED		0x0002
#define	FLAG_NEG_TWO		0x0004
#define	FLAG_NEG_ONE		0x0008
#define	FLAG_SUPPORTED		0x0010



// data types *****************************************************************

typedef struct
{
	const char*	text;
	int			cmd;
	int			flags;
} test_ioctl_t;



// variables ******************************************************************

static test_ioctl_t	_cmds[]	=
{
	{ ENTRY(SIO4_IOCTL_REG_READ)				},
	{ ENTRY(SIO4_IOCTL_REG_WRITE)				},
	{ ENTRY(SIO4_IOCTL_REG_MOD)					},
	{ ENTRY(SIO4_IOCTL_QUERY)					},
	{ ENTRY(SIO4_IOCTL_INITIALIZE)				},
	{ ENTRY(SIO4_IOCTL_CBL_MODE)				},
	{ ENTRY(SIO4_IOCTL_CBL_PIN_STATUS)			},
	{ ENTRY(SIO4_IOCTL_FIFO_SPACE_CFG)			},
	{ ENTRY(SIO4_IOCTL_GPIO_DIRECTION_OUT)		},
	{ ENTRY(SIO4_IOCTL_GPIO_INPUT_LATCHING)		},

	{ ENTRY(SIO4_IOCTL_GPIO_INPUT_READ)			},
	{ ENTRY(SIO4_IOCTL_GPIO_OUTPUT_WRITE)		},
	{ ENTRY(SIO4_IOCTL_GPIO_POLARITY)			},
	{ ENTRY(SIO4_IOCTL_GPIO_SENSE_EDGE)			},
	{ ENTRY(SIO4_IOCTL_IRQ_GSC_CFG_HIGH)		},
	{ ENTRY(SIO4_IOCTL_IRQ_GSC_ENABLE)			},
	{ ENTRY(SIO4_IOCTL_IRQ_USC_ENABLE)			},
	{ ENTRY(SIO4_IOCTL_LED_CHANNEL)				},
	{ ENTRY(SIO4_IOCTL_LED_MAIN)				},
	{ ENTRY(SIO4_IOCTL_LOOP_BACK)				},

	{ ENTRY(SIO4_IOCTL_OSC_MEASURE)				},
	{ ENTRY(SIO4_IOCTL_OSC_PROGRAM)				},
	{ ENTRY(SIO4_IOCTL_OSC_REFERENCE)			},
	{ ENTRY(SIO4_IOCTL_RX_FIFO_AE)				},
	{ ENTRY(SIO4_IOCTL_RX_FIFO_AF)				},
	{ ENTRY(SIO4_IOCTL_RX_FIFO_FILL_LEVEL)		},
	{ ENTRY(SIO4_IOCTL_RX_FIFO_FULL_CFG)		},
	{ ENTRY(SIO4_IOCTL_RX_FIFO_FULL_CFG_GLB)	},
	{ ENTRY(SIO4_IOCTL_RX_FIFO_OVERRUN)			},
	{ ENTRY(SIO4_IOCTL_RX_FIFO_RESET)			},
	{ ENTRY(SIO4_IOCTL_RX_FIFO_STATUS)			},

	{ ENTRY(SIO4_IOCTL_RX_FIFO_UNDERRUN)		},
	{ ENTRY(SIO4_IOCTL_RX_IO_MODE)				},
	{ ENTRY(SIO4_IOCTL_RX_IO_OVERRUN)			},
	{ ENTRY(SIO4_IOCTL_RX_IO_PIO_THRESHOLD)		},
	{ ENTRY(SIO4_IOCTL_RX_IO_TIMEOUT)			},
	{ ENTRY(SIO4_IOCTL_RX_IO_UNDERRUN)			},
	{ ENTRY(SIO4_IOCTL_SYNC_LEG_RXD_CFG)		},
	{ ENTRY(SIO4_IOCTL_SYNC_LEG_TXD_CFG)		},
	{ ENTRY(SIO4_IOCTL_SYNC_MODE)				},
	{ ENTRY(SIO4_IOCTL_SYNC_RX_BIT_COUNT)		},

	{ ENTRY(SIO4_IOCTL_SYNC_RX_BIT_ORDER)		},
	{ ENTRY(SIO4_IOCTL_SYNC_RX_COUNT_ERROR)		},
	{ ENTRY(SIO4_IOCTL_SYNC_RX_COUNT_RESET)		},
	{ ENTRY(SIO4_IOCTL_SYNC_RX_ENABLE)			},
	{ ENTRY(SIO4_IOCTL_SYNC_RX_GAP_ENABLE)		},
	{ ENTRY(SIO4_IOCTL_SYNC_RXC_CFG)			},
	{ ENTRY(SIO4_IOCTL_SYNC_RXC_POL)			},
	{ ENTRY(SIO4_IOCTL_SYNC_RXD_CFG)			},
	{ ENTRY(SIO4_IOCTL_SYNC_RXE_CFG)			},
	{ ENTRY(SIO4_IOCTL_SYNC_RXE_POL)			},

	{ ENTRY(SIO4_IOCTL_SYNC_TX_WORD_SIZE)		},
	{ ENTRY(SIO4_IOCTL_SYNC_TX_BIT_ORDER)		},
	{ ENTRY(SIO4_IOCTL_SYNC_TX_ENABLE)			},
	{ ENTRY(SIO4_IOCTL_SYNC_TX_GAP_SIZE)		},
	{ ENTRY(SIO4_IOCTL_SYNC_TXAUXC_CFG)			},
	{ ENTRY(SIO4_IOCTL_SYNC_TXC_CFG)			},
	{ ENTRY(SIO4_IOCTL_SYNC_TXC_IDLE)			},
	{ ENTRY(SIO4_IOCTL_SYNC_TXC_IDLE_CFG)		},
	{ ENTRY(SIO4_IOCTL_SYNC_TXC_POL)			},
	{ ENTRY(SIO4_IOCTL_SYNC_TXC_SRC)			},

	{ ENTRY(SIO4_IOCTL_SYNC_TXD_CFG)			},
	{ ENTRY(SIO4_IOCTL_SYNC_TXD_IDLE_CFG)		},
	{ ENTRY(SIO4_IOCTL_SYNC_TXE_CFG)			},
	{ ENTRY(SIO4_IOCTL_SYNC_TXE_POL)			},
	{ ENTRY(SIO4_IOCTL_SYNC_TXSP_CFG)			},
	{ ENTRY(SIO4_IOCTL_TIME_STAMP_COUNT)		},
	{ ENTRY(SIO4_IOCTL_TIME_STAMP_ENABLE)		},
	{ ENTRY(SIO4_IOCTL_TIME_STAMP_SRC)			},
	{ ENTRY(SIO4_IOCTL_TIME_STAMP_VAL)			},
	{ ENTRY(SIO4_IOCTL_TX_FIFO_AE)				},

	{ ENTRY(SIO4_IOCTL_TX_FIFO_AF)				},
	{ ENTRY(SIO4_IOCTL_TX_FIFO_EMPTY_CFG)		},
	{ ENTRY(SIO4_IOCTL_TX_FIFO_FILL_LEVEL)		},
	{ ENTRY(SIO4_IOCTL_TX_FIFO_OVERRUN)			},
	{ ENTRY(SIO4_IOCTL_TX_FIFO_RESET)			},
	{ ENTRY(SIO4_IOCTL_TX_FIFO_STATUS)			},
	{ ENTRY(SIO4_IOCTL_TX_IO_MODE)				},
	{ ENTRY(SIO4_IOCTL_TX_IO_OVERRUN)			},
	{ ENTRY(SIO4_IOCTL_TX_IO_PIO_THRESHOLD)		},
	{ ENTRY(SIO4_IOCTL_TX_IO_TIMEOUT)			},

	{ ENTRY(SIO4_IOCTL_XCVR_ENABLE)				},
	{ ENTRY(SIO4_IOCTL_XCVR_PROTOCOL)			},
	{ ENTRY(SIO4_IOCTL_XCVR_TERM)				},
	{ ENTRY(SIO4_IOCTL_Z16_CBL_DCD_CFG)			},
	{ ENTRY(SIO4_IOCTL_Z16_CBL_DTR_DSR_CFG)		},
	{ ENTRY(SIO4_IOCTL_Z16_CBL_RTS_CFG)			},
	{ ENTRY(SIO4_IOCTL_Z16_CBL_TXAUXC_CFG)		},
	{ ENTRY(SIO4_IOCTL_Z16_CBL_TXC_CFG)			},
	{ ENTRY(SIO4_IOCTL_Z16_CBL_TXD_CFG)			},
	{ ENTRY(SIO4_IOCTL_Z16_LEG_RXC)				},

	{ ENTRY(SIO4_IOCTL_Z16_LEG_RXD_DCD_CFG)		},
	{ ENTRY(SIO4_IOCTL_Z16_LEG_TXC)				},
	{ ENTRY(SIO4_IOCTL_Z16_LEG_TXD_CTS_CFG)		},
	{ ENTRY(SIO4_IOCTL_Z16_RX_STS_WRD_ENABLE)	},
	{ ENTRY(SIO4_IOCTL_Z16_SYNC_BYTE)			},
	{ ENTRY(SIO4_IOCTL_WAIT_EVENT)				},
	{ ENTRY(SIO4_IOCTL_WAIT_CANCEL)				},
	{ ENTRY(SIO4_IOCTL_WAIT_STATUS)				},
	{ ENTRY(SIO4_IOCTL_RX_IO_ABORT)				},
	{ ENTRY(SIO4_IOCTL_TX_IO_ABORT)				},

	{ ENTRY(SIO4_IOCTL_USC_8023_RX_ADRS_SRCH)	},
	{ ENTRY(SIO4_IOCTL_USC_8023_TX_UNDERRUN)	},
	{ ENTRY(SIO4_IOCTL_USC_ACCEPT_CV)			},
	{ ENTRY(SIO4_IOCTL_USC_ACV_RX_EXT_W)		},
	{ ENTRY(SIO4_IOCTL_USC_ACV_TX_CV_POL)		},
	{ ENTRY(SIO4_IOCTL_USC_ACV_TX_EXT_W)		},
	{ ENTRY(SIO4_IOCTL_USC_ACV_TX_STOP_BIT)		},
	{ ENTRY(SIO4_IOCTL_USC_ASYNC_RX_CLK_RATE)	},
	{ ENTRY(SIO4_IOCTL_USC_ASYNC_TX_CLK_RATE)	},
	{ ENTRY(SIO4_IOCTL_USC_ASYNC_TX_STOP_BIT)	},

	{ ENTRY(SIO4_IOCTL_USC_BRG0_CLK_SRC)		},
	{ ENTRY(SIO4_IOCTL_USC_BRG0_ENABLE)			},
	{ ENTRY(SIO4_IOCTL_USC_BRG0_MODE)			},
	{ ENTRY(SIO4_IOCTL_USC_BRG1_CLK_SRC)		},
	{ ENTRY(SIO4_IOCTL_USC_BRG1_ENABLE)			},
	{ ENTRY(SIO4_IOCTL_USC_BRG1_MODE)			},
	{ ENTRY(SIO4_IOCTL_USC_BSC_RX_SHORT)		},
	{ ENTRY(SIO4_IOCTL_USC_BSC_RX_STRIP)		},
	{ ENTRY(SIO4_IOCTL_USC_BSC_RX_SYN0)			},
	{ ENTRY(SIO4_IOCTL_USC_BSC_RX_SYN1)			},

	{ ENTRY(SIO4_IOCTL_USC_BSC_TX_PREAMBLE)		},
	{ ENTRY(SIO4_IOCTL_USC_BSC_TX_SHORT)		},
	{ ENTRY(SIO4_IOCTL_USC_BSC_TX_SYN0)			},
	{ ENTRY(SIO4_IOCTL_USC_BSC_TX_SYN1)			},
	{ ENTRY(SIO4_IOCTL_USC_BSC_TX_UNDERRUN)		},
	{ ENTRY(SIO4_IOCTL_USC_CTR0_CLK_SRC)		},
	{ ENTRY(SIO4_IOCTL_USC_CTR0_RATE)			},
	{ ENTRY(SIO4_IOCTL_USC_CTR1_CLK_SRC)		},
	{ ENTRY(SIO4_IOCTL_USC_CTR1_RATE)			},
	{ ENTRY(SIO4_IOCTL_USC_CTS_CFG)				},

	{ ENTRY(SIO4_IOCTL_USC_DCD_CFG)				},
	{ ENTRY(SIO4_IOCTL_USC_DPLL_ADJ_SYNC)		},
	{ ENTRY(SIO4_IOCTL_USC_DPLL_CLK_SRC)		},
	{ ENTRY(SIO4_IOCTL_USC_DPLL_MISS_1)			},
	{ ENTRY(SIO4_IOCTL_USC_DPLL_MISS_2)			},
	{ ENTRY(SIO4_IOCTL_USC_DPLL_MODE)			},
	{ ENTRY(SIO4_IOCTL_USC_DPLL_RATE)			},
	{ ENTRY(SIO4_IOCTL_USC_DPLL_SYNC)			},
	{ ENTRY(SIO4_IOCTL_USC_HDLC_RX_ADRS_CTRL)	},
	{ ENTRY(SIO4_IOCTL_USC_HDLC_TX_L_CHR_LEN)	},

	{ ENTRY(SIO4_IOCTL_USC_HDLC_TX_PREAMBLE)	},
	{ ENTRY(SIO4_IOCTL_USC_HDLC_TX_SHARE_0)		},
	{ ENTRY(SIO4_IOCTL_USC_HDLC_TX_UNDERRUN)	},
	{ ENTRY(SIO4_IOCTL_USC_HDLCL_TX_ACTIVE)		},
	{ ENTRY(SIO4_IOCTL_USC_HDLCL_TX_SHARE_0)	},
	{ ENTRY(SIO4_IOCTL_USC_HDLCL_TX_UNDERRUN)	},
	{ ENTRY(SIO4_IOCTL_USC_ISOC_TX_STOP_BIT)	},
	{ ENTRY(SIO4_IOCTL_USC_LOOP_SENDING)		},
	{ ENTRY(SIO4_IOCTL_USC_MONO_RX_SHORT)		},
	{ ENTRY(SIO4_IOCTL_USC_MONO_RX_STRIP)		},

	{ ENTRY(SIO4_IOCTL_USC_MONO_RX_SYNC)		},
	{ ENTRY(SIO4_IOCTL_USC_MONO_TX_CRC_UNDER)	},
	{ ENTRY(SIO4_IOCTL_USC_MONO_TX_PREAMBLE)	},
	{ ENTRY(SIO4_IOCTL_USC_MONO_TX_SHORT)		},
	{ ENTRY(SIO4_IOCTL_USC_MONO_TX_SYNC)		},
	{ ENTRY(SIO4_IOCTL_USC_NBIP_RX_CLK_RATE)	},
	{ ENTRY(SIO4_IOCTL_USC_NBIP_RX_PARITY)		},
	{ ENTRY(SIO4_IOCTL_USC_NBIP_TX_ADRS_BIT)	},
	{ ENTRY(SIO4_IOCTL_USC_NBIP_TX_CLK_RATE)	},
	{ ENTRY(SIO4_IOCTL_USC_NBIP_TX_PARITY)		},

	{ ENTRY(SIO4_IOCTL_USC_ON_LOOP)				},
	{ ENTRY(SIO4_IOCTL_USC_OPER_MODE)			},
	{ ENTRY(SIO4_IOCTL_USC_RCC_FIFO_CLEAR)		},
	{ ENTRY(SIO4_IOCTL_USC_RCC_FIFO_OVERRUN)	},
	{ ENTRY(SIO4_IOCTL_USC_RCC_FIFO_VALID)		},
	{ ENTRY(SIO4_IOCTL_USC_RESET)				},
	{ ENTRY(SIO4_IOCTL_USC_RX_CHAR_CNT)			},
	{ ENTRY(SIO4_IOCTL_USC_RX_CHAR_CNT_LIM)		},
	{ ENTRY(SIO4_IOCTL_USC_RX_CHAR_LEN)			},
	{ ENTRY(SIO4_IOCTL_USC_RX_CLK_SRC)			},

	{ ENTRY(SIO4_IOCTL_USC_RX_CMD)				},
	{ ENTRY(SIO4_IOCTL_USC_RX_CRC_ENABLE)		},
	{ ENTRY(SIO4_IOCTL_USC_RX_CRC_PRESET)		},
	{ ENTRY(SIO4_IOCTL_USC_RX_CRC_TYPE)			},
	{ ENTRY(SIO4_IOCTL_USC_RX_DATA_ENCODE)		},
	{ ENTRY(SIO4_IOCTL_USC_RX_ENABLE)			},
	{ ENTRY(SIO4_IOCTL_USC_RX_MODE)				},
	{ ENTRY(SIO4_IOCTL_USC_RX_PAR_ENABLE)		},
	{ ENTRY(SIO4_IOCTL_USC_RX_PAR_TYPE)			},
	{ ENTRY(SIO4_IOCTL_USC_RX_QUEUE_ABORT)		},

	{ ENTRY(SIO4_IOCTL_USC_RX_STATUS)			},
	{ ENTRY(SIO4_IOCTL_USC_RX_STATUS_BLOCK)		},
	{ ENTRY(SIO4_IOCTL_USC_RX_WAIT_DMA_TRIG)	},
	{ ENTRY(SIO4_IOCTL_USC_RXC_CFG)				},
	{ ENTRY(SIO4_IOCTL_USC_SEND_COMMAND)		},
	{ ENTRY(SIO4_IOCTL_USC_SMONO_RX_SYNC)		},
	{ ENTRY(SIO4_IOCTL_USC_SMONO_TX_ACTIVE)		},
	{ ENTRY(SIO4_IOCTL_USC_SMONO_TX_SHORT)		},
	{ ENTRY(SIO4_IOCTL_USC_SMONO_TX_SYNC)		},
	{ ENTRY(SIO4_IOCTL_USC_SMONO_TX_UNDERRUN)	},

	{ ENTRY(SIO4_IOCTL_USC_TBSC_RX_ENCODING)	},
	{ ENTRY(SIO4_IOCTL_USC_TBSC_TX_ENCODING)	},
	{ ENTRY(SIO4_IOCTL_USC_TBSC_TX_PREAMBLE)	},
	{ ENTRY(SIO4_IOCTL_USC_TBSC_TX_UNDERRUN)	},
	{ ENTRY(SIO4_IOCTL_USC_TC0)					},
	{ ENTRY(SIO4_IOCTL_USC_TC1)					},
	{ ENTRY(SIO4_IOCTL_USC_TX_CHAR_CNT)			},
	{ ENTRY(SIO4_IOCTL_USC_TX_CHAR_CNT_LIM)		},
	{ ENTRY(SIO4_IOCTL_USC_TX_CHAR_LEN)			},
	{ ENTRY(SIO4_IOCTL_USC_TX_CLK_SRC)			},

	{ ENTRY(SIO4_IOCTL_USC_TX_CMD)				},
	{ ENTRY(SIO4_IOCTL_USC_TX_CRC_ENABLE)		},
	{ ENTRY(SIO4_IOCTL_USC_TX_CRC_ON_END)		},
	{ ENTRY(SIO4_IOCTL_USC_TX_CRC_PRESET)		},
	{ ENTRY(SIO4_IOCTL_USC_TX_CRC_TYPE)			},
	{ ENTRY(SIO4_IOCTL_USC_TX_DATA_ENCODE)		},
	{ ENTRY(SIO4_IOCTL_USC_TX_ENABLE)			},
	{ ENTRY(SIO4_IOCTL_USC_TX_IDLE_COND)		},
	{ ENTRY(SIO4_IOCTL_USC_TX_MODE)				},
	{ ENTRY(SIO4_IOCTL_USC_TX_PAR_ENABLE)		},

	{ ENTRY(SIO4_IOCTL_USC_TX_PAR_TYPE)			},
	{ ENTRY(SIO4_IOCTL_USC_TX_PREAMBLE_FLAG)	},
	{ ENTRY(SIO4_IOCTL_USC_TX_PREAMBLE_LEN)		},
	{ ENTRY(SIO4_IOCTL_USC_TX_PREAMBLE_PAT)		},
	{ ENTRY(SIO4_IOCTL_USC_TX_STATUS)			},
	{ ENTRY(SIO4_IOCTL_USC_TX_CTRL_BLOCK)		},
	{ ENTRY(SIO4_IOCTL_USC_TX_WAIT_DMA_TRIG)	},
	{ ENTRY(SIO4_IOCTL_USC_TX_WAIT_UNDERRUN)	},
	{ ENTRY(SIO4_IOCTL_USC_TXC_CFG)				},
	{ ENTRY(SIO4_IOCTL_USC_TXD_CFG)				},
	{ ENTRY(SIO4_IOCTL_USC_TXC_LEG)				},
	{ ENTRY(SIO4_IOCTL_USC_RXC_LEG)				},
	{ ENTRY(SIO4_IOCTL_USC_CTS_LEG)				},
	{ ENTRY(SIO4_IOCTL_USC_DCD_LEG)				},
	{ ENTRY(SIO4_IOCTL_REG_READ_RAW)			},
	{ ENTRY(SIO4_IOCTL_RCC_SW_FIFO_ENABLE)		},
	{ ENTRY(SIO4_IOCTL_RCC_SW_FIFO_FLUSH)		},
	{ ENTRY(SIO4_IOCTL_RCC_SW_FIFO_READ)		}
};



//*****************************************************************************
static int _mark_defined(const char* cmd)
{
	int	errs	= 1;	// An error indicated we don't have it in our list.
	int	i;

	for (i = 0; i < (int) ARRAY_ELEMENTS(_cmds); i++)
	{
		if (strcmp(cmd, _cmds[i].text) == 0)
		{
			errs			= 0;
			_cmds[i].flags	|= FLAG_DEFINED;
			break;
		}
	}

	if (errs)
	{
		printf("\n");
		gsc_label_level_inc();
		gsc_label("Not In Program's List");
		printf("%s\t", cmd);
		gsc_label_level_dec();
	}

	return(errs);
}



//*****************************************************************************
static const char* _skipws(const char* psz)
{
	for (; (psz) && (isspace(psz[0]));)
		psz++;

	return(psz);
}



//*****************************************************************************
static int _process_line(const char* src)
{
	char		buf[128];
	int			errs	= 0;
	int			i;
	const char*	psz;

	for (;;)	// A convenience loop.
	{
		psz	= _skipws(src);

		if (psz[0] != '#')
			break;

		psz	= _skipws(psz + 1);

		if (memcmp(psz, "define", 6))
			break;

		psz	= _skipws(psz + 6);

		if (memcmp(psz, "SIO4_IOCTL_", 11))
			break;

		memset(buf, 0, sizeof(buf));

		for (i = 0; i < (int) sizeof(buf); i++)
		{
			if (isspace(psz[i]))
				break;

			buf[i]	= psz[i];
		}

		errs	+= _mark_defined(buf);
		break;
	}

	return(errs);
}



//*****************************************************************************
static int _test_file(const char* name, const char* arg0, const char* dir, char* dest, int size)
{
	long	len;
	int		ret		= 0;

	strncpy(dest, arg0, size);
	dest[size - 1]	= 0;
	len	= strlen(dest);

	for (; len; len--)
	{
		if (dest[len - 1] == '/')
			break;

		if (dest[len - 1] == '\\')
			break;

		dest[len - 1]	= 0;
	}

	strcat(dest, dir);
	strcat(dest, name);
	ret	= file_test(dest);
	return(ret);
}



//*****************************************************************************
static int _scan_header_file(const char* name, const char* arg0)
{
	char	buf[1024];
	int		eof		= 0;
	int		errs	= 0;
	FILE*	file;
	int		len;
	char	path[2048];
	int		sts;

	sprintf(buf, "Scanning %s", name);
	gsc_label(buf);

	sts	= _test_file(name, arg0, "../driver/", path, sizeof(path));

	if (sts == 0)
		sts	= _test_file(name, arg0, "../../driver/", path, sizeof(path));

	if (sts == 0)
		sts	= _test_file(name, arg0, "../include/", path, sizeof(path));

	if (sts == 0)
		sts	= _test_file(name, arg0, "../../include/", path, sizeof(path));

	if (sts == 0)
		sts	= _test_file(name, arg0, "../../../include/", path, sizeof(path));

	if (sts == 0)
		sts	= _test_file(name, arg0, "../../../../include/", path, sizeof(path));

	if (sts == 0)
	{
		errs++;
		printf("FAIL <---  (Unable to locate %s)\n", name);
	}
	else
	{
		file	= file_open(path);

		if (file)
		{
			for (;;)	// Read from the file til we're done.
			{
				len	= file_read_line(path, file, buf, sizeof(buf));

				if (len == -1)
				{
					errs++;
					printf("FAIL <---  (Read error on %s.)\n", path);
					break;
				}

				if (len)
					errs	+= _process_line(buf);

				sts	= file_eof(path, file, &eof);

				if (sts == -1)
				{
					errs++;
					printf("FAIL <---  (EOF access error on %s.)\n", path);
					break;
				}

				if (eof)
					break;
			}

			file_close(path, file);
		}
		else
		{
			errs++;
			printf("FAIL <---  (Access error on %s.)\n", path);
		}

		printf("%s\n", errs ? "" : "PASS");
	}

	return(errs);
}



//*****************************************************************************
static int _arg_minus_two(int fd, int verbose)
{
	s32	arg;
	int	errs	= 0;
	int	i;
	int	size;
	int	sts;

	gsc_label("Validating Argument (-2)");
	gsc_label_level_inc();

	if (verbose)
		printf("\n");

	for (i = 0; i < (int) ARRAY_ELEMENTS(_cmds); i++)
	{
		if (verbose)
			gsc_label(_cmds[i].text);

		size	= OS_IOCTL_SIZE_DECODE(_cmds[i].cmd);

		if (size != 4)
		{
			if (verbose)
				printf("Skipped\n");

			continue;
		}

		fflush(stdout);
		arg	= -2;
		sts	= sio4_ioctl(fd, _cmds[i].cmd, &arg);

		if (sts < 0)
		{
			if (verbose)
				printf("PASS\n");

			continue;
		}

		if (verbose)
			printf("FAILED  (returned %ld)\n", (long) sts);

		// This value should fail in virtually all services.
		errs++;
		_cmds[i].flags	|= FLAG_NEG_TWO;
	}

	if (verbose == 0)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	if (verbose == 0)
	{
		for (i = 0; i < (int) ARRAY_ELEMENTS(_cmds); i++)
		{
			if (_cmds[i].flags & FLAG_NEG_TWO)
			{
				gsc_label("Failed Test");
				printf("%s\n", _cmds[i].text);
			}
		}
	}

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
static int _arg_minus_one(int fd, int verbose)
{
	s32	arg;
	int	errs	= 0;
	int	i;
	int	size;
	int	sts;

	gsc_label("Validating Argument (-1)");
	gsc_label_level_inc();

	if (verbose)
		printf("\n");

	for (i = 0; i < (int) ARRAY_ELEMENTS(_cmds); i++)
	{
		if (verbose)
			gsc_label(_cmds[i].text);

		size	= OS_IOCTL_SIZE_DECODE(_cmds[i].cmd);

		if (size != 4)
		{
			if (verbose)
				printf("Skipped\n");

			continue;
		}

		fflush(stdout);
		arg	= -1;
		sts	= sio4_ioctl(fd, _cmds[i].cmd, &arg);

		if (sts == 0)
		{
			if (verbose)
				printf("PASS\n");

			if (arg != -1)
				_cmds[i].flags	|= FLAG_SUPPORTED;

			continue;
		}

		if (verbose)
			printf("FAILED  (returned %ld)\n", (long) sts);

		// This value should pass in virtually all services.
		errs++;
		_cmds[i].flags	|= FLAG_NEG_ONE;
	}

	if (verbose == 0)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	if (verbose == 0)
	{
		for (i = 0; i < (int) ARRAY_ELEMENTS(_cmds); i++)
		{
			if (_cmds[i].flags & FLAG_NEG_ONE)
			{
				gsc_label("Failed Test");
				printf("%s\n", _cmds[i].text);
			}
		}
	}

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
static void _list_supported(void)
{
	int	i;
	int	size;

	gsc_label("Supported Services");
	printf("\n");
	gsc_label_level_inc();

	for (i = 0; i < (int) ARRAY_ELEMENTS(_cmds); i++)
	{
		size	= OS_IOCTL_SIZE_DECODE(_cmds[i].cmd);

		if (size != 4)
		{
			gsc_label(_cmds[i].text);
			printf("Yes\n");
			continue;
		}

		if (_cmds[i].flags	& FLAG_SUPPORTED)
		{
			gsc_label(_cmds[i].text);
			printf("Yes\n");
			continue;
		}

		if (_cmds[i].flags	& FLAG_NEG_ONE)
		{
			gsc_label(_cmds[i].text);
			printf("Possibly\n");
			continue;
		}
	}

	gsc_label_level_dec();
}



//*****************************************************************************
static void _list_unsupported(void)
{
	int	i;
	int	size;

	gsc_label("Unsupported Services");
	printf("\n");
	gsc_label_level_inc();

	for (i = 0; i < (int) ARRAY_ELEMENTS(_cmds); i++)
	{
		size	= OS_IOCTL_SIZE_DECODE(_cmds[i].cmd);

		if (size != 4)
			continue;

		if (_cmds[i].flags	& FLAG_SUPPORTED)
			continue;

		if (_cmds[i].flags	& FLAG_NEG_ONE)
		{
			gsc_label(_cmds[i].text);
			printf("Possibly\n");
			continue;
		}

		gsc_label(_cmds[i].text);
		printf("No\n");
	}

	gsc_label_level_dec();
}



//*****************************************************************************
int services(int fd, int verbose, int supported, int unsupported, const char* arg0)
{
	int	errs	= 0;

	errs	+= _scan_header_file("sio4.h", arg0);
	errs	+= _scan_header_file("sio4_usc.h", arg0);
	errs	+= _arg_minus_two(fd, verbose);
	errs	+= _arg_minus_one(fd, verbose);

	if (supported)
		_list_supported();

	if (unsupported)
		_list_unsupported();

	return(errs);
}


