// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/services/main.c $
// $Rev: 33972 $
// $Date: 2015-11-05 19:03:11 -0600 (Thu, 05 Nov 2015) $

#include "main.h"



// variables ******************************************************************

static	int	_def_index		= 0;
static	int	_unsupported	= 0;
static	int	_verbose		= 0;



//*****************************************************************************
static int _parse_args(int argc, char** argv)
{
	char	buf[32];
	char	c;
	int		errs	= 0;
	int		i;
	int		j;
	int		k;

	printf("services - Identify supported IOCTL services . (Version %s)\n", VERSION);
	printf("USAGE: services <-u> <-v> index\n");
	printf("  -u     List services which are unsupported by this board.\n");
	printf("  -v     Verbose processing.\n");
	printf("  index  The zero based index of the channel to access (default is 0).\n");

	gsc_label_level_inc();

	for (i = 0; i < argc; i++)
	{
		sprintf(buf, "Argument %d", i);
		gsc_label(buf);
		printf("%s\n", argv[i]);
	}

	gsc_label_level_dec();

	for (i = 1; i < argc; i++)
	{
		if (strcmp(argv[i], "-u") == 0)
		{
			_unsupported	= 1;
			continue;
		}

		if (strcmp(argv[i], "-v") == 0)
		{
			_verbose	= 1;
			continue;
		}

		j	= sscanf(argv[i], "%d%c", &k, &c);

		if ((j == 1) && (k >= 0))
		{
			_def_index	= k;
			continue;
		}

		errs	= 1;
		printf("ERROR: invalid channel index: %s\n", argv[i]);
		break;
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	_perform_tests
*
*	Purpose:
*
*		Perform the appropriate testing.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*		argv0	The path to the executable, including the executable.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

static int _perform_tests(int fd, const char* argv0)
{
	int			errs	= 0;
	const char*	psz;
	struct tm*	stm;
	time_t		tt;

	time(&tt);
	stm	= localtime(&tt);
	psz	= asctime(stm);
	gsc_label("Performing Test");
	printf("%s", psz);

	errs	+= sio4_id_board(fd, -1);
	errs	+= services(fd, _verbose, 1, _unsupported, argv0);
	return(errs);
}



/******************************************************************************
*
*	Function:	main
*
*	Purpose:
*
*		Control the overall operation of the application.
*
*	Arguments:
*
*		argc	The number of command line arguments.
*
*		argv	The list of command line arguments.
*
*	Returned:
*
*		EXIT_SUCCESS	No errors were encounterred.
*		EXIT_FAILURE	One or more errors were encounterred.
*
******************************************************************************/

int main(int argc, char** argv)
{
	int		errs		= 0;
	time_t	exec		= time(NULL);
	long	failures	= 0;
	int		fd;
	long	hours;
	long	mins;
	time_t	now;
	long	passes		= 0;
	int		qty;
	int		ret			= EXIT_SUCCESS;
	long	secs;
	long	tests		= 0;

	for (;;)	// A convenience loop.
	{
		gsc_label_init(34);
		errs	+= _parse_args(argc, argv);

		if (errs)
			break;

		os_id_host();
		errs	+= os_id_driver(SIO4_BASE_NAME);

		if (errs)
			break;

		qty	= os_count_boards(SIO4_BASE_NAME);

		if (qty <= 0)
		{
			errs++;
			break;
		}

		gsc_label("Testing Channel Index");
		printf("%d\n", _def_index);

		fd	= sio4_dev_open(_def_index, -1, 1);

		if (fd == -1)
		{
			errs	= 1;
		}
		else
		{
			errs	= _perform_tests(fd, argv[0]);
			errs	+= sio4_dev_close(fd, -1, 1);
		}

		tests		= 1;
		passes		= errs ? 0 : 1;
		failures	= errs ? 1 : 0;

		now		= time(NULL);
		secs	= (long) (now - exec);
		hours	= secs / 3600;
		secs	= secs % 3600;
		mins	= secs / 60;
		secs	= secs % 60;
		printf(	"SUMMARY: tests %ld, pass %ld, fail %ld"
				" (duration %ld:%ld:%02ld)\n\n",
				tests,
				passes,
				failures,
				hours,
				mins,
				secs);


		break;
	}

	if (errs)
		ret	= EXIT_FAILURE;

	return(ret);
}


