// $URL: http://subversion:8080/svn/gsc/trunk/drivers/RTX/sio4/sio4_Linux_3.x_GSC_DN/root/main.c $
// $Rev: 33980 $
// $Date: 2015-11-05 22:30:17 -0600 (Thu, 05 Nov 2015) $

#include "main.h"



//*****************************************************************************
static int _parse_args(int argc, char** argv)
{
	int	errs	= 0;
	int	i;

	printf("root - Display the contents of the driver's root device (Version %s)\n", VERSION);
	printf("USAGE: root\n");

	for (i = 0; i < argc; i++)
		printf("  Argument %d: %s\n", i, argv[i]);

	for (i = 1; i < argc; i++)
	{
		errs	= 1;
		printf("ERROR: invalid argument: %s\n", argv[i]);
		break;
	}

	return(errs);
}



//*****************************************************************************
static int _dump_driver_root(void)
{
	char		buf[4096];
	int			errs	= 0;
	int			fd;
	int			ret;

	printf("Driver Root: ");
	fd	= sio4_open(-1);

	if (fd < 0)
	{
		errs	= 1;
		printf("FAIL <---  (Unable to open Driver Root Device.)\n");
	}
	else
	{
		memset(buf, 0, sizeof(buf));
		ret	= sio4_read(fd, buf, sizeof(buf));
		buf[sizeof(buf) - 1]	= 0;
		sio4_close(fd);

		if (ret > 0)
		{
			printf("\n\n%s\n", buf);
		}
		else
		{
			errs	= 1;
			printf("FAIL: read error\n");
		}
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	main
*
*	Purpose:
*
*		Control the overall operation of the application.
*
*	Arguments:
*
*		argc	The number of command line arguments.
*
*		argv	The list of command line arguments.
*
*	Returned:
*
*		EXIT_SUCCESS	No errors were encounterred.
*		EXIT_FAILURE	One or more errors were encounterred.
*
******************************************************************************/

int main(int argc, char** argv)
{
	int	errs	= 0;
	int	ret		= EXIT_SUCCESS;

	errs	= _parse_args(argc, argv);

	if (errs == 0)
		errs	= _dump_driver_root();

	if (errs)
	{
		printf(	"\nRESULTS: FAIL <---  (%d error%s)\n",
				errs,
				(errs == 1) ? "" : "s");
	}
	else
	{
		printf("\nRESULTS: PASS\n");
	}

	if (errs)
		ret	= EXIT_FAILURE;

	return(ret);
}


