// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/regs/main_menu.c $
// $Rev: 33938 $
// $Date: 2015-10-07 15:26:43 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
static void _id_host(int fd)
{
	os_id_host();
}



//*****************************************************************************
static void _id_driver(int fd)
{
	os_id_driver(SIO4_BASE_NAME);
}



//*****************************************************************************
static void _id_board(int fd)
{
	sio4_id_board(fd, -1);
}



//*****************************************************************************
static void _dump_pci(int fd)
{
	u32	did;

	sio4_reg_read(fd, GSC_PCI_9056_DIDR, &did);

	if (did == 0x9056)
		gsc_reg_plx9056_list_pci(fd, sio4_reg_read);
	else
		gsc_reg_plx9080_list_pci(fd, sio4_reg_read);
}



//*****************************************************************************
static void _dump_plx(int fd)
{
	u32	did;

	sio4_reg_read(fd, GSC_PCI_9056_DIDR, &did);

	if (did == 0x9056)
		gsc_reg_plx9056_list_plx(fd, sio4_reg_read);
	else
		gsc_reg_plx9080_list_plx(fd, sio4_reg_read);
}



//*****************************************************************************
static void _dump_gsc(int fd)
{
	sio4_reg_list(fd, 1, 0, 0, 0);
}



//*****************************************************************************
static void _dump_gsc_detail(int fd)
{
	sio4_reg_list(fd, 1, 1, 0, 0);
}



//*****************************************************************************
static void _dump_usc_regs(int fd, int detail)
{
	int	errs;
	s32	fw	= 0;

	errs	= sio4_query(fd, SIO4_QUERY_FW_TYPE, &fw);

	if (errs)
	{
		printf("FAIL <---  (sio4_query() error)\n");
	}
	else if (fw == SIO4_FW_TYPE_Z16C30)
	{
		sio4_reg_list(fd, 0, 0, 1, detail);
	}
	else
	{
		printf(	"USC REGISTER LIST: SKIPPED  "
				"(This is not a Z16C30 based SIO4.)\n");
	}
}



//*****************************************************************************
static void _dump_usc(int fd)
{
	_dump_usc_regs(fd, 0);
}



//*****************************************************************************
static void _dump_usc_detail(int fd)
{
	_dump_usc_regs(fd, 1);
}



//*****************************************************************************
static void _dump_everything(int fd)
{
	_id_host(fd);
	printf("\n");
	_id_driver(fd);
	printf("\n");
	_id_board(fd);
	printf("\n");
	_dump_pci(fd);
	printf("\n");
	_dump_plx(fd);
	printf("\n");
	_dump_gsc_detail(fd);
	printf("\n");
	_dump_usc_detail(fd);
}



/*****************************************************************************
*
*	Function:	main_menu
*
*	Purpose:
*
*		Present the main menu.
*
*	Arguments:
*
*		fd		The handle for the board to access.
*
*	Returned:
*
*		None.
*
*****************************************************************************/

void main_menu(int fd)
{
	static const menu_item_t	list[]	=
	{
		// name								func
		{ "Dump Everything",				_dump_everything	},
		{ "Host OS Identification",			_id_host			},
		{ "Driver Identification",			_id_driver			},
		{ "Board Identification",			_id_board			},
		{ "PCI Register Dump",				_dump_pci			},
		{ "PLX Register Dump",				_dump_plx			},
		{ "GSC Register Dump",				_dump_gsc			},
		{ "GSC Register Detail Dump",		_dump_gsc_detail	},
		{ "USC Register Dump",				_dump_usc			},
		{ "USC Register Detail Dump",		_dump_usc_detail	},
		{ "Edit GSC Register By Name",		reg_mod_by_name		},
		{ "Edit GSC Register By Offset",	reg_mod_by_offset	},
		{ NULL,								NULL				}
	};

	static const menu_t	menu	=
	{
		/* title	*/	"Main Menu",
		/* list		*/	list
	};

	printf("\n\n");
	printf("Register Access Application (version %s)\n", VERSION);
	menu_call(fd, &menu);
}



