// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/regs/main.h $
// $Rev: 33956 $
// $Date: 2015-11-01 15:22:13 -0600 (Sun, 01 Nov 2015) $

#ifndef __MAIN_H__
#define __MAIN_H__

#include <ctype.h>
#include <stdlib.h>
#include <time.h>

#include "sio4_lib.h"
#include "sio4_dsl.h"
#include "sio4_utils.h"



// #defines *******************************************************************

#define	VERSION			"2.6"
// 2.6	Set the default channel selection to zero.
// 2.5	Simplified error messages.
// 2.4	Additional LINTing.
// 2.3	LINTing for INtime.
// 2.2	USC registers are not accessed for SYNC boards.
//		Reorganized "dump all" implementation.
// 2.1	Updated the prototype for sio4_id_board.
//		Updated the help text.
//		Updated per changes to common utility code.
//		Channel selection is now required on the command line.
//		Updated open/close error processing.
// 2.0	Port to the 2.x driver.
// 1.0	initial release.



// data types *****************************************************************

typedef struct
{
	const char*	name;				// NULL terminates list.
	void		(*func)(int fd);	// NULL terminates list.
} menu_item_t;

typedef struct
{
	const char*			title;
	const menu_item_t*	list;
} menu_t;



// prototypes *****************************************************************

void	main_menu(int fd);
void	menu_call(int fd, const menu_t* menu);
int		menu_select(const menu_t* menu);
void	reg_mod_by_name(int fd);
void	reg_mod_by_offset(int fd);



#endif
