// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/regs/main.c $
// $Rev: 33956 $
// $Date: 2015-11-01 15:22:13 -0600 (Sun, 01 Nov 2015) $

#include "main.h"



// variables ******************************************************************

static	int	_def_index	= 0;



/*****************************************************************************
*
*	Function:	_parse_args
*
*	Purpose:
*
*		Parse the command line arguments.
*
*	Arguments:
*
*		argc	The number of command line arguments given.
*
*		argv	The list of command line arguments given.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
*****************************************************************************/

static int _parse_args(int argc, char** argv)
{
	char	buf[32];
	char	c;
	int		errs	= 0;
	int		i;
	int		j;
	int		k;

	printf("regs - Register Access Application (Version %s)\n", VERSION);
	printf("USAGE: regs index\n");
	printf("  index  The zero based index of the channel to access (default is 0).\n");

	gsc_label_level_inc();

	for (i = 0; i < argc; i++)
	{
		sprintf(buf, "Argument %d", i);
		gsc_label(buf);
		printf("%s\n", argv[i]);
	}

	gsc_label_level_dec();

	for (i = 1; i < argc; i++)
	{
		j	= sscanf(argv[i], "%d%c", &k, &c);

		if ((j == 1) && (k >= 0))
		{
			_def_index	= k;
			continue;
		}

		errs	= 1;
		printf("ERROR: invalid channel selection: %s\n", argv[i]);
		break;
	}

	return(errs);
}



/*****************************************************************************
*
*	Function:	main
*
*	Purpose:
*
*		Control the overall operation of the application.
*
*	Arguments:
*
*		argc			The number of command line arguments.
*
*		argv			The list of command line arguments.
*
*	Returned:
*
*		EXIT_SUCCESS	We tested a device.
*		EXIT_FAILURE	We didn't test a device.
*
*****************************************************************************/

int main(int argc, char** argv)
{
	int		errs	= 0;
	int		fd		= 0;
	int		qty;
	int		ret		= EXIT_FAILURE;

	for (;;)
	{
		gsc_label_init(28);
		errs	+= _parse_args(argc, argv);

		if (errs)
			break;

		os_id_host();
		errs	+= os_id_driver(SIO4_BASE_NAME);

		if (errs)
			break;

		qty	= os_count_boards(SIO4_BASE_NAME);

		if (qty <= 0)
			break;

		gsc_label("Accessing Channel Index");
		printf("%d\n", _def_index);

		fd	= sio4_dev_open(_def_index, -1, 1);

		if (fd == -1)
		{
			errs	= 1;
		}
		else
		{
			main_menu(fd);
			errs	+= sio4_dev_close(fd, -1, 1);
		}

		break;
	}

	if (errs == 0)
		ret		= EXIT_SUCCESS;

	return(ret);
}



